/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.IOException;
import java.util.BitSet;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.scan.FullStoreChangeStream;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanStore;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;

public class NativeLabelScanStoreIT {
    private final TestDirectory directory = TestDirectory.testDirectory(this.getClass());
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final LifeRule life = new LifeRule(true);
    private final RandomRule random = new RandomRule();
    @Rule
    public final RuleChain rules = RuleChain.outerRule((TestRule)this.directory).around((TestRule)this.pageCacheRule).around((TestRule)this.life).around((TestRule)this.random);
    private NativeLabelScanStore store;
    private static final int NODE_COUNT = 10000;
    private static final int LABEL_COUNT = 12;

    @Before
    public void before() {
        PageCache pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)new DefaultFileSystemAbstraction());
        this.store = (NativeLabelScanStore)this.life.add((Lifecycle)new NativeLabelScanStore(pageCache, this.directory.absolutePath(), FullStoreChangeStream.EMPTY, false, new Monitors(), Math.min(pageCache.pageSize(), 256 << this.random.nextInt(5))));
    }

    @Test
    public void shouldRandomlyTestIt() throws Exception {
        long[] expected = new long[10000];
        this.randomModifications(expected, 10000);
        for (int i = 0; i < 100; ++i) {
            this.verifyReads(expected);
            this.randomModifications(expected, 1000);
        }
    }

    private void verifyReads(long[] expected) {
        try (LabelScanReader reader = this.store.newReader();){
            for (int i = 0; i < 12; ++i) {
                long[] actualNodes = PrimitiveLongCollections.asArray((PrimitiveLongIterator)reader.nodesWithLabel(i));
                long[] expectedNodes = NativeLabelScanStoreIT.nodesWithLabel(expected, i);
                Assert.assertArrayEquals((long[])expectedNodes, (long[])actualNodes);
            }
        }
    }

    public static long[] nodesWithLabel(long[] expected, int labelId) {
        int mask = 1 << labelId;
        int count = 0;
        for (long labels : expected) {
            if ((labels & (long)mask) == 0L) continue;
            ++count;
        }
        long[] result = new long[count];
        int cursor = 0;
        for (int nodeId = 0; nodeId < expected.length; ++nodeId) {
            long labels;
            labels = expected[nodeId];
            if ((labels & (long)mask) == 0L) continue;
            result[cursor++] = nodeId;
        }
        return result;
    }

    private void randomModifications(long[] expected, int count) throws IOException {
        BitSet editedNodes = new BitSet();
        try (LabelScanWriter writer = this.store.newWriter();){
            for (int i = 0; i < count; ++i) {
                int nodeId = this.random.nextInt(10000);
                if (editedNodes.get(nodeId)) {
                    --i;
                    continue;
                }
                int changeSize = this.random.nextInt(3) + 1;
                long labels = expected[nodeId];
                long[] labelsBefore = NativeLabelScanStoreIT.getLabels(labels);
                for (int j = 0; j < changeSize; ++j) {
                    labels = NativeLabelScanStoreIT.flipRandom(labels, 12, this.random.random());
                }
                long[] labelsAfter = NativeLabelScanStoreIT.getLabels(labels);
                editedNodes.set(nodeId);
                NodeLabelUpdate labelChanges = NodeLabelUpdate.labelChanges((long)nodeId, (long[])labelsBefore, (long[])labelsAfter);
                writer.write(labelChanges);
                expected[nodeId] = labels;
            }
        }
    }

    public static long flipRandom(long existingLabels, int highLabelId, Random random) {
        return existingLabels ^ (long)(1 << random.nextInt(highLabelId));
    }

    public static long[] getLabels(long bits) {
        long[] result = new long[Long.bitCount(bits)];
        int c = 0;
        for (int labelId = 0; labelId < 12; ++labelId) {
            int mask = 1 << labelId;
            if ((bits & (long)mask) == 0L) continue;
            result[c++] = labelId;
        }
        return result;
    }
}

