/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.kernel.impl.locking.ActiveLock;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.LockingCompatibilityTestSuite;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.lock.ResourceType;

@Ignore(value="Not a test. This is a compatibility suite, run from LockingCompatibilityTestSuite.")
public class ActiveLocksListingCompatibility
extends LockingCompatibilityTestSuite.Compatibility {
    public ActiveLocksListingCompatibility(LockingCompatibilityTestSuite suite) {
        super(suite);
    }

    @Test
    public void shouldListLocksHeldByTheCurrentClient() throws Exception {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L, 2L, 3L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{3L, 4L, 5L});
        Stream locks = this.clientA.activeLocks();
        Assert.assertEquals(new HashSet<ActiveLock>(Arrays.asList(ActiveLock.exclusiveLock((ResourceType)ResourceTypes.NODE, (long)1L), ActiveLock.exclusiveLock((ResourceType)ResourceTypes.NODE, (long)2L), ActiveLock.exclusiveLock((ResourceType)ResourceTypes.NODE, (long)3L), ActiveLock.sharedLock((ResourceType)ResourceTypes.NODE, (long)3L), ActiveLock.sharedLock((ResourceType)ResourceTypes.NODE, (long)4L), ActiveLock.sharedLock((ResourceType)ResourceTypes.NODE, (long)5L))), locks.collect(Collectors.toSet()));
    }

    @Test
    public void shouldCountNumberOfActiveLocks() throws Exception {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.SCHEMA, new long[]{0L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{17L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{12L});
        long count = this.clientA.activeLockCount();
        Assert.assertEquals((long)3L, (long)count);
    }
}

