/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.impl.locking.ResourceTypes;

public class IndexEntryResourceTypesTest {
    public static final int labelId = 1;
    public static final int propertyId = 2;
    public static final String value = "value";

    @Test
    public void shouldProduceBackwardsCompatibleId() {
        long id = ResourceTypes.indexEntryResourceId((long)1L, (IndexQuery.ExactPredicate[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)2, (Object)value)});
        MatcherAssert.assertThat((Object)id, (Matcher)Matchers.equalTo((Object)155667838465249649L));
    }

    @Test
    public void shouldDifferentiateBetweenIndexes() {
        IndexQuery.ExactPredicate pred1 = IndexQuery.exact((int)1, (Object)value);
        IndexQuery.ExactPredicate pred2 = IndexQuery.exact((int)1, (Object)"value2");
        IndexQuery.ExactPredicate pred3 = IndexQuery.exact((int)2, (Object)value);
        IndexQuery.ExactPredicate pred4 = IndexQuery.exact((int)2, (Object)"value2");
        List<Long> ids = Arrays.asList(ResourceTypes.indexEntryResourceId((long)1L, (IndexQuery.ExactPredicate[])((IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{pred1}))), ResourceTypes.indexEntryResourceId((long)1L, (IndexQuery.ExactPredicate[])((IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{pred2}))), ResourceTypes.indexEntryResourceId((long)1L, (IndexQuery.ExactPredicate[])((IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{pred3}))), ResourceTypes.indexEntryResourceId((long)1L, (IndexQuery.ExactPredicate[])((IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{pred4}))), ResourceTypes.indexEntryResourceId((long)2L, (IndexQuery.ExactPredicate[])((IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{pred1}))), ResourceTypes.indexEntryResourceId((long)1L, (IndexQuery.ExactPredicate[])((IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{pred1, pred2}))), ResourceTypes.indexEntryResourceId((long)1L, (IndexQuery.ExactPredicate[])((IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{pred1, pred2, pred3}))), ResourceTypes.indexEntryResourceId((long)2L, (IndexQuery.ExactPredicate[])((IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{pred1, pred2, pred3, pred4}))));
        Set uniqueIds = Iterables.asSet(ids);
        MatcherAssert.assertThat((Object)ids.size(), (Matcher)Matchers.equalTo((Object)uniqueIds.size()));
    }
}

