/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.test.Race;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class NeoStoresIT {
    @ClassRule
    public static final DatabaseRule db = new EmbeddedDatabaseRule().withSetting(GraphDatabaseSettings.dense_node_threshold, "1");
    private static final RelationshipType FRIEND = RelationshipType.withName((String)"FRIEND");
    private static final String LONG_STRING_VALUE = "ALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALONG!!";

    @Test
    public void shouldWriteOutTheDynamicChainBeforeUpdatingThePropertyRecord() throws Throwable {
        Race race = new Race();
        long[] latestNodeId = new long[1];
        AtomicLong writes = new AtomicLong();
        AtomicLong reads = new AtomicLong();
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(2L);
        race.withEndCondition(() -> writes.get() > 100L && reads.get() > 10000L || System.currentTimeMillis() > endTime);
        race.addContestant(() -> {
            try (Transaction tx = db.beginTx();){
                Node node = db.createNode();
                latestNodeId[0] = node.getId();
                node.setProperty("largeProperty", (Object)LONG_STRING_VALUE);
                tx.success();
            }
            writes.incrementAndGet();
        });
        race.addContestant(() -> {
            try (Transaction tx = db.getGraphDatabaseAPI().beginTx();){
                Node node = db.getGraphDatabaseAPI().getNodeById(latestNodeId[0]);
                for (String propertyKey : node.getPropertyKeys()) {
                    node.getProperty(propertyKey);
                }
                tx.success();
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            reads.incrementAndGet();
        });
        race.go();
    }

    @Test
    public void shouldWriteOutThePropertyRecordBeforeReferencingItFromANodeRecord() throws Throwable {
        Race race = new Race();
        long[] latestNodeId = new long[1];
        AtomicLong writes = new AtomicLong();
        AtomicLong reads = new AtomicLong();
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(2L);
        race.withEndCondition(() -> writes.get() > 100L && reads.get() > 10000L || System.currentTimeMillis() > endTime);
        race.addContestant(() -> {
            try (Transaction tx = db.beginTx();){
                Node node = db.createNode();
                latestNodeId[0] = node.getId();
                node.setProperty("largeProperty", (Object)LONG_STRING_VALUE);
                tx.success();
            }
            writes.incrementAndGet();
        });
        race.addContestant(() -> {
            block15: {
                try (Transaction tx = db.getGraphDatabaseAPI().beginTx();){
                    Node node = db.getGraphDatabaseAPI().getNodeById(latestNodeId[0]);
                    for (String propertyKey : node.getPropertyKeys()) {
                        node.getProperty(propertyKey);
                    }
                    tx.success();
                }
                catch (NotFoundException e) {
                    if (!Exceptions.contains((Throwable)e, (Class[])new Class[]{InvalidRecordException.class})) break block15;
                    throw e;
                }
            }
            reads.incrementAndGet();
        });
        race.go();
    }

    @Test
    public void shouldWriteOutThePropertyRecordBeforeReferencingItFromARelationshipRecord() throws Throwable {
        long node2Id;
        long node1Id;
        try (Transaction tx = db.beginTx();){
            Node node1 = db.createNode();
            node1Id = node1.getId();
            Node node2 = db.createNode();
            node2Id = node2.getId();
            tx.success();
        }
        Race race = new Race();
        long[] latestRelationshipId = new long[1];
        AtomicLong writes = new AtomicLong();
        AtomicLong reads = new AtomicLong();
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(2L);
        race.withEndCondition(() -> writes.get() > 100L && reads.get() > 10000L || System.currentTimeMillis() > endTime);
        race.addContestant(() -> {
            try (Transaction tx = db.beginTx();){
                Node node1 = db.getGraphDatabaseAPI().getNodeById(node1Id);
                Node node2 = db.getGraphDatabaseAPI().getNodeById(node2Id);
                Relationship rel = node1.createRelationshipTo(node2, FRIEND);
                latestRelationshipId[0] = rel.getId();
                rel.setProperty("largeProperty", (Object)LONG_STRING_VALUE);
                tx.success();
            }
            writes.incrementAndGet();
        });
        race.addContestant(() -> {
            block15: {
                try (Transaction tx = db.getGraphDatabaseAPI().beginTx();){
                    Relationship rel = db.getGraphDatabaseAPI().getRelationshipById(latestRelationshipId[0]);
                    for (String propertyKey : rel.getPropertyKeys()) {
                        rel.getProperty(propertyKey);
                    }
                    tx.success();
                }
                catch (NotFoundException e) {
                    if (!Exceptions.contains((Throwable)e, (Class[])new Class[]{InvalidRecordException.class})) break block15;
                    throw e;
                }
            }
            reads.incrementAndGet();
        });
        race.go();
    }
}

