/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.JumpingIdGeneratorFactory;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class PropertyStoreTest {
    @ClassRule
    public static PageCacheRule pageCacheRule = new PageCacheRule(PageCacheRule.config().withInconsistentReads(false));
    @Rule
    public final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private EphemeralFileSystemAbstraction fileSystemAbstraction;
    private File path;

    @Before
    public void setup() throws IOException {
        this.fileSystemAbstraction = (EphemeralFileSystemAbstraction)this.fsRule.get();
        this.path = new File("/tmp/foobar");
        this.fileSystemAbstraction.mkdir(this.path.getParentFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldWriteOutTheDynamicChainBeforeUpdatingThePropertyRecord() throws IOException {
        PageCache pageCache = pageCacheRule.getPageCache((FileSystemAbstraction)this.fileSystemAbstraction);
        Config config = Config.embeddedDefaults(Collections.singletonMap(PropertyStore.Configuration.rebuild_idgenerators_fast.name(), "true"));
        DynamicStringStore stringPropertyStore = (DynamicStringStore)Mockito.mock(DynamicStringStore.class);
        store.initialise(true);
        try (final PropertyStore store = new PropertyStore(this.path, config, (IdGeneratorFactory)new JumpingIdGeneratorFactory(1), pageCache, (LogProvider)NullLogProvider.getInstance(), stringPropertyStore, (PropertyKeyTokenStore)Mockito.mock(PropertyKeyTokenStore.class), (DynamicArrayStore)Mockito.mock(DynamicArrayStore.class), RecordFormatSelector.defaultFormat(), new OpenOption[0]);){
            store.makeStoreOk();
            final long propertyRecordId = store.nextId();
            PropertyRecord record = new PropertyRecord(propertyRecordId);
            record.setInUse(true);
            DynamicRecord dynamicRecord = this.dynamicRecord();
            PropertyBlock propertyBlock = this.propertyBlockWith(dynamicRecord);
            record.setPropertyBlock(propertyBlock);
            ((DynamicStringStore)Mockito.doAnswer((Answer)new Answer(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    PropertyRecord recordBeforeWrite = (PropertyRecord)store.getRecord(propertyRecordId, (AbstractBaseRecord)store.newRecord(), RecordLoad.FORCE);
                    Assert.assertFalse((boolean)recordBeforeWrite.inUse());
                    return null;
                }
            }).when((Object)stringPropertyStore)).updateRecord((AbstractBaseRecord)dynamicRecord);
            store.updateRecord(record);
            ((DynamicStringStore)Mockito.verify((Object)stringPropertyStore)).updateRecord((AbstractBaseRecord)dynamicRecord);
        }
    }

    private DynamicRecord dynamicRecord() {
        DynamicRecord dynamicRecord = new DynamicRecord(42L);
        dynamicRecord.setType(PropertyType.STRING.intValue());
        dynamicRecord.setCreated();
        return dynamicRecord;
    }

    private PropertyBlock propertyBlockWith(DynamicRecord dynamicRecord) {
        PropertyBlock propertyBlock = new PropertyBlock();
        PropertyKeyTokenRecord key = new PropertyKeyTokenRecord(10);
        propertyBlock.setSingleBlock(key.getId() | (long)PropertyType.STRING.intValue() << 24 | dynamicRecord.getId() << 28);
        propertyBlock.addValueRecord(dynamicRecord);
        return propertyBlock;
    }
}

