/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;

public class RecordCursorsTest {
    @Test
    public void closesCursors() {
        RecordCursors cursors = RecordCursorsTest.newRecordCursorsWithMockedNeoStores();
        cursors.close();
        RecordCursorsTest.verifyAllCursorsClosed(cursors);
    }

    @Test
    public void closesCursorsEvenIfSomeCursorFailsToClose() {
        RecordCursors cursors = RecordCursorsTest.newRecordCursorsWithMockedNeoStores();
        RecordCursor relGroupCursor = cursors.relationshipGroup();
        RuntimeException exception = new RuntimeException("Close failure");
        ((RecordCursor)Mockito.doThrow((Throwable)exception).when((Object)relGroupCursor)).close();
        try {
            cursors.close();
        }
        catch (Exception e) {
            Assert.assertSame((Object)exception, (Object)e.getCause());
        }
        RecordCursorsTest.verifyAllCursorsClosed(cursors);
    }

    private static void verifyAllCursorsClosed(RecordCursors recordCursors) {
        ((RecordCursor)Mockito.verify((Object)recordCursors.node())).close();
        ((RecordCursor)Mockito.verify((Object)recordCursors.relationship())).close();
        ((RecordCursor)Mockito.verify((Object)recordCursors.relationshipGroup())).close();
        ((RecordCursor)Mockito.verify((Object)recordCursors.property())).close();
        ((RecordCursor)Mockito.verify((Object)recordCursors.propertyString())).close();
        ((RecordCursor)Mockito.verify((Object)recordCursors.propertyArray())).close();
        ((RecordCursor)Mockito.verify((Object)recordCursors.label())).close();
    }

    private static RecordCursors newRecordCursorsWithMockedNeoStores() {
        NeoStores neoStores = (NeoStores)Mockito.mock(NeoStores.class);
        NodeStore nodeStore = RecordCursorsTest.newStoreMockWithRecordCursor(NodeStore.class);
        RelationshipStore relStore = RecordCursorsTest.newStoreMockWithRecordCursor(RelationshipStore.class);
        RelationshipGroupStore relGroupStore = RecordCursorsTest.newStoreMockWithRecordCursor(RelationshipGroupStore.class);
        PropertyStore propertyStore = RecordCursorsTest.newStoreMockWithRecordCursor(PropertyStore.class);
        DynamicStringStore dynamicStringStore = RecordCursorsTest.newStoreMockWithRecordCursor(DynamicStringStore.class);
        DynamicArrayStore dynamicArrayStore = RecordCursorsTest.newStoreMockWithRecordCursor(DynamicArrayStore.class);
        DynamicArrayStore dynamicLabelStore = RecordCursorsTest.newStoreMockWithRecordCursor(DynamicArrayStore.class);
        Mockito.when((Object)neoStores.getNodeStore()).thenReturn((Object)nodeStore);
        Mockito.when((Object)neoStores.getRelationshipStore()).thenReturn((Object)relStore);
        Mockito.when((Object)neoStores.getRelationshipGroupStore()).thenReturn((Object)relGroupStore);
        Mockito.when((Object)neoStores.getPropertyStore()).thenReturn((Object)propertyStore);
        Mockito.when((Object)propertyStore.getStringStore()).thenReturn((Object)dynamicStringStore);
        Mockito.when((Object)propertyStore.getArrayStore()).thenReturn((Object)dynamicArrayStore);
        Mockito.when((Object)nodeStore.getDynamicLabelStore()).thenReturn((Object)dynamicLabelStore);
        return new RecordCursors(neoStores);
    }

    private static <S extends RecordStore<R>, R extends AbstractBaseRecord> S newStoreMockWithRecordCursor(Class<S> storeClass) {
        RecordStore storeMock = (RecordStore)Mockito.mock(storeClass);
        RecordCursor cursor = RecordCursorsTest.newCursorMock();
        Mockito.when((Object)storeMock.newRecordCursor((AbstractBaseRecord)Matchers.any())).thenReturn(cursor);
        return (S)storeMock;
    }

    private static <T extends AbstractBaseRecord> RecordCursor<T> newCursorMock() {
        RecordCursor cursor = (RecordCursor)Mockito.mock(RecordCursor.class);
        Mockito.when((Object)cursor.acquire(Matchers.anyLong(), (RecordLoad)Matchers.any())).thenReturn((Object)cursor);
        return cursor;
    }
}

