/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.InvalidIdGeneratorException;
import org.neo4j.kernel.impl.store.id.IdGeneratorImpl;
import org.neo4j.kernel.impl.store.id.validation.IdCapacityExceededException;
import org.neo4j.kernel.impl.store.id.validation.NegativeIdException;
import org.neo4j.test.ProcessTestUtil;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class IdGeneratorImplTest {
    @Rule
    public final EphemeralFileSystemRule fsr = new EphemeralFileSystemRule();
    private final File file = new File("ids");

    @Test
    public void shouldNotAcceptMinusOne() throws Exception {
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fsr.get(), (File)this.file, (long)0L, (boolean)false);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.fsr.get(), this.file, 100, 100L, false, 0L);
        try {
            idGenerator.setHighId(-1L);
            Assert.fail((String)"Should have failed");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(NegativeIdException.class));
        }
    }

    @Test
    public void throwsWhenNextIdIsTooHigh() {
        long maxId = 10L;
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fsr.get(), (File)this.file, (long)0L, (boolean)false);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.fsr.get(), this.file, 1, maxId, false, 0L);
        for (long i = 0L; i <= maxId; ++i) {
            idGenerator.nextId();
        }
        try {
            idGenerator.nextId();
            Assert.fail((String)"Should have failed");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IdCapacityExceededException.class));
        }
    }

    @Test
    public void throwsWhenGivenHighIdIsTooHigh() {
        long maxId = 10L;
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fsr.get(), (File)this.file, (long)0L, (boolean)false);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.fsr.get(), this.file, 1, maxId, false, 0L);
        try {
            idGenerator.setHighId(maxId + 1L);
            Assert.fail((String)"Should have failed");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IdCapacityExceededException.class));
        }
    }

    @Test
    public void highIdCouldBeSetToReservedId() {
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fsr.get(), (File)this.file, (long)0L, (boolean)false);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.fsr.get(), this.file, 1, Long.MAX_VALUE, false, 0L);
        idGenerator.setHighId(0xFFFFFFFFL);
        Assert.assertEquals((long)0x100000000L, (long)idGenerator.nextId());
    }

    @Test
    public void correctDefragCountWhenHaveIdsInFile() {
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fsr.get(), (File)this.file, (long)0L, (boolean)false);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.fsr.get(), this.file, 100, 100L, true, 100L);
        idGenerator.freeId(5L);
        idGenerator.close();
        IdGeneratorImpl reloadedIdGenerator = new IdGeneratorImpl(this.fsr.get(), this.file, 100, 100L, true, 100L);
        Assert.assertEquals((long)1L, (long)reloadedIdGenerator.getDefragCount());
        Assert.assertEquals((long)5L, (long)reloadedIdGenerator.nextId());
        Assert.assertEquals((long)0L, (long)reloadedIdGenerator.getDefragCount());
    }

    @Test
    public void shouldReadHighIdUsingStaticMethod() throws Exception {
        long highId = 12345L;
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fsr.get(), (File)this.file, (long)highId, (boolean)false);
        long readHighId = IdGeneratorImpl.readHighId((FileSystemAbstraction)this.fsr.get(), (File)this.file);
        Assert.assertEquals((long)highId, (long)readHighId);
    }

    @Test
    public void shouldBeAbleToReadWrittenGenerator() {
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fsr.get(), (File)this.file, (long)0L, (boolean)false);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.fsr.get(), this.file, 100, 100L, false, 42L);
        idGenerator.close();
        idGenerator = new IdGeneratorImpl(this.fsr.get(), this.file, 100, 100L, false, 0L);
        Assert.assertThat((Object)idGenerator.getHighId(), (Matcher)Matchers.equalTo((Object)42L));
    }

    @Test
    public void shouldForceStickyMark() throws Exception {
        try (DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();){
            File dir = new File("target/test-data/" + this.getClass().getName());
            fs.mkdirs(dir);
            File file = new File(dir, "ids");
            fs.deleteFile(file);
            IdGeneratorImpl.createGenerator((FileSystemAbstraction)fs, (File)file, (long)0L, (boolean)false);
            ProcessTestUtil.executeSubProcess(this.getClass(), 1L, TimeUnit.MINUTES, file.getAbsolutePath());
            try {
                IdGeneratorImpl.readHighId((FileSystemAbstraction)fs, (File)file);
                Assert.fail((String)"Should have thrown, saying something with sticky generator");
            }
            catch (InvalidIdGeneratorException invalidIdGeneratorException) {
                // empty catch block
            }
        }
    }

    @Test
    public void shouldDeleteIfOpen() throws Exception {
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fsr.get(), (File)this.file, (long)42L, (boolean)false);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.fsr.get(), this.file, 100, 100L, false, 42L);
        idGenerator.delete();
        Assert.assertFalse((boolean)((EphemeralFileSystemAbstraction)this.fsr.get()).fileExists(this.file));
    }

    @Test
    public void shouldDeleteIfClosed() throws Exception {
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fsr.get(), (File)this.file, (long)42L, (boolean)false);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.fsr.get(), this.file, 100, 100L, false, 42L);
        idGenerator.close();
        idGenerator.delete();
        Assert.assertFalse((boolean)((EphemeralFileSystemAbstraction)this.fsr.get()).fileExists(this.file));
    }

    @Test
    public void shouldTruncateTheFileIfOverwriting() throws Exception {
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fsr.get(), (File)this.file, (long)10L, (boolean)true);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.fsr.get(), this.file, 5, 100L, false, 30L);
        for (int i = 0; i < 17; ++i) {
            idGenerator.freeId((long)i);
        }
        idGenerator.close();
        Assert.assertThat((Object)((int)((EphemeralFileSystemAbstraction)this.fsr.get()).getFileSize(this.file)), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(9)));
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fsr.get(), (File)this.file, (long)30L, (boolean)false);
        Assert.assertEquals((long)9L, (long)((int)((EphemeralFileSystemAbstraction)this.fsr.get()).getFileSize(this.file)));
        Assert.assertEquals((long)30L, (long)IdGeneratorImpl.readHighId((FileSystemAbstraction)this.fsr.get(), (File)this.file));
        idGenerator = new IdGeneratorImpl(this.fsr.get(), this.file, 5, 100L, false, 30L);
        Assert.assertEquals((long)30L, (long)idGenerator.nextId());
    }

    public static void main(String[] args) throws IOException {
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();){
            new IdGeneratorImpl((FileSystemAbstraction)fileSystem, new File(args[0]), 100, 100L, false, 42L);
        }
        System.exit(0);
    }
}

