/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;

public class LogHeaderCacheTest {
    @Test
    public void shouldReturnNullWhenThereIsNoHeaderInTheCache() {
        LogHeaderCache cache = new LogHeaderCache(2);
        Long logHeader = cache.getLogHeader(5L);
        Assert.assertEquals(null, (Object)logHeader);
    }

    @Test
    public void shouldReturnTheHeaderIfInTheCache() {
        LogHeaderCache cache = new LogHeaderCache(2);
        cache.putHeader(5L, 3L);
        long logHeader = cache.getLogHeader(5L);
        Assert.assertEquals((long)3L, (long)logHeader);
    }

    @Test
    public void shouldClearTheCache() {
        LogHeaderCache cache = new LogHeaderCache(2);
        cache.putHeader(5L, 3L);
        cache.clear();
        Long logHeader = cache.getLogHeader(5L);
        Assert.assertEquals(null, (Object)logHeader);
    }
}

