/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.IntPredicate;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.labelscan.AllEntriesLabelScanReader;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.index.NodeUpdates;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.transaction.state.storeview.DynamicIndexStoreView;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.storageengine.api.schema.LabelScanReader;

public class DynamicIndexStoreViewTest {
    private final LabelScanStore labelScanStore = (LabelScanStore)Mockito.mock(LabelScanStore.class);
    private final NeoStores neoStores = (NeoStores)Mockito.mock(NeoStores.class);
    private final NodeStore nodeStore = (NodeStore)Mockito.mock(NodeStore.class);
    private final CountsTracker countStore = (CountsTracker)Mockito.mock(CountsTracker.class);
    private final Visitor<NodeUpdates, Exception> propertyUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);
    private final Visitor<NodeLabelUpdate, Exception> labelUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);
    private final IntPredicate propertyKeyIdFilter = (IntPredicate)Mockito.mock(IntPredicate.class);
    private final AllEntriesLabelScanReader nodeLabelRanges = (AllEntriesLabelScanReader)Mockito.mock(AllEntriesLabelScanReader.class);

    @Before
    public void setUp() {
        NodeRecord nodeRecord = this.getNodeRecord();
        Mockito.when((Object)this.labelScanStore.allNodeLabelRanges()).thenReturn((Object)this.nodeLabelRanges);
        Mockito.when((Object)this.neoStores.getCounts()).thenReturn((Object)this.countStore);
        Mockito.when((Object)this.neoStores.getNodeStore()).thenReturn((Object)this.nodeStore);
        Mockito.when((Object)this.nodeStore.newRecord()).thenReturn((Object)nodeRecord);
        Mockito.when((Object)this.nodeStore.getRecord(Matchers.anyLong(), (AbstractBaseRecord)Matchers.any(NodeRecord.class), (RecordLoad)Matchers.any(RecordLoad.class))).thenReturn((Object)nodeRecord);
    }

    @Test
    public void visitAllNodesWhenThresholdReached() throws Exception {
        Mockito.when((Object)this.nodeStore.getHighestPossibleIdInUse()).thenReturn((Object)10L);
        Mockito.when((Object)this.nodeStore.getHighId()).thenReturn((Object)10L);
        this.mockLabelNodeCount(this.countStore, 1);
        this.mockLabelNodeCount(this.countStore, 2);
        this.mockLabelNodeCount(this.countStore, 3);
        DynamicIndexStoreView storeView = new DynamicIndexStoreView(this.labelScanStore, LockService.NO_LOCK_SERVICE, this.neoStores, (LogProvider)NullLogProvider.getInstance());
        StoreScan storeScan = storeView.visitNodes(new int[]{1, 2, 3}, this.propertyKeyIdFilter, this.propertyUpdateVisitor, this.labelUpdateVisitor, false);
        storeScan.run();
        ((NodeStore)Mockito.verify((Object)this.nodeStore, (VerificationMode)Mockito.times((int)10))).getRecord(Matchers.anyLong(), (AbstractBaseRecord)Matchers.any(NodeRecord.class), (RecordLoad)Matchers.any(RecordLoad.class));
    }

    @Test
    public void visitOnlyLabeledNodesWhenThresholdNotReached() throws Exception {
        LabelScanReader labelScanReader = (LabelScanReader)Mockito.mock(LabelScanReader.class);
        Mockito.when((Object)this.labelScanStore.newReader()).thenReturn((Object)labelScanReader);
        Mockito.when((Object)this.nodeLabelRanges.maxCount()).thenReturn((Object)1L);
        PrimitiveLongIterator labeledNodesIterator = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L});
        Mockito.when((Object)this.nodeStore.getHighestPossibleIdInUse()).thenReturn((Object)200L);
        Mockito.when((Object)this.nodeStore.getHighId()).thenReturn((Object)20L);
        Mockito.when((Object)labelScanReader.nodesWithAnyOfLabels(new int[]{2, 6})).thenReturn((Object)labeledNodesIterator);
        this.mockLabelNodeCount(this.countStore, 2);
        this.mockLabelNodeCount(this.countStore, 6);
        DynamicIndexStoreView storeView = new DynamicIndexStoreView(this.labelScanStore, LockService.NO_LOCK_SERVICE, this.neoStores, (LogProvider)NullLogProvider.getInstance());
        StoreScan storeScan = storeView.visitNodes(new int[]{2, 6}, this.propertyKeyIdFilter, this.propertyUpdateVisitor, this.labelUpdateVisitor, false);
        storeScan.run();
        ((NodeStore)Mockito.verify((Object)this.nodeStore, (VerificationMode)Mockito.times((int)8))).getRecord(Matchers.anyLong(), (AbstractBaseRecord)Matchers.any(NodeRecord.class), (RecordLoad)Matchers.any(RecordLoad.class));
    }

    @Test
    public void shouldBeAbleToForceStoreScan() throws Exception {
        Mockito.when((Object)this.labelScanStore.newReader()).thenThrow(new Throwable[]{new RuntimeException("Should not be used")});
        PrimitiveLongIterator labeledNodesIterator = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L});
        Mockito.when((Object)this.nodeStore.getHighestPossibleIdInUse()).thenReturn((Object)200L);
        Mockito.when((Object)this.nodeStore.getHighId()).thenReturn((Object)20L);
        this.mockLabelNodeCount(this.countStore, 2);
        this.mockLabelNodeCount(this.countStore, 6);
        DynamicIndexStoreView storeView = new DynamicIndexStoreView(this.labelScanStore, LockService.NO_LOCK_SERVICE, this.neoStores, (LogProvider)NullLogProvider.getInstance());
        StoreScan storeScan = storeView.visitNodes(new int[]{2, 6}, this.propertyKeyIdFilter, this.propertyUpdateVisitor, this.labelUpdateVisitor, true);
        storeScan.run();
        ((NodeStore)Mockito.verify((Object)this.nodeStore, (VerificationMode)Mockito.times((int)20))).getRecord(Matchers.anyLong(), (AbstractBaseRecord)Matchers.any(NodeRecord.class), (RecordLoad)Matchers.any(RecordLoad.class));
    }

    private NodeRecord getNodeRecord() {
        NodeRecord nodeRecord = new NodeRecord(0L);
        nodeRecord.initialize(true, 1L, false, 1L, 0L);
        return nodeRecord;
    }

    private void mockLabelNodeCount(CountsTracker countStore, int labelId) {
        Register.DoubleLongRegister register = Registers.newDoubleLongRegister((long)labelId, (long)labelId);
        Mockito.when((Object)countStore.nodeCount(Matchers.eq((int)labelId), (Register.DoubleLongRegister)Matchers.any(Register.DoubleLongRegister.class))).thenReturn((Object)register);
    }
}

