/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metatest;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class TestEphemeralFileChannel {
    @Rule
    public final EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();

    @Test
    public void smoke() throws Exception {
        EphemeralFileSystemAbstraction fs = (EphemeralFileSystemAbstraction)this.fileSystemRule.get();
        StoreChannel channel = fs.open(new File("yo"), "rw");
        ByteBuffer buffer = ByteBuffer.allocateDirect(23);
        buffer.put(new byte[23]);
        buffer.flip();
        channel.write(buffer);
        channel = fs.open(new File("yo"), "rw");
        long longValue = 1234567890L;
        buffer.clear();
        buffer.limit(1);
        buffer.put((byte)1);
        buffer.flip();
        channel.write(buffer);
        buffer.clear();
        buffer.limit(1);
        buffer.put((byte)2);
        buffer.flip();
        channel.position(6L);
        channel.write(buffer);
        buffer.clear();
        buffer.limit(8);
        buffer.putLong(longValue);
        buffer.flip();
        channel.position(15L);
        channel.write(buffer);
        Assert.assertEquals((long)23L, (long)channel.size());
        buffer.clear();
        buffer.limit(1);
        channel.read(buffer, 0L);
        buffer.flip();
        Assert.assertEquals((long)1L, (long)buffer.get());
        buffer.clear();
        buffer.limit(3);
        channel.read(buffer, 5L);
        buffer.flip();
        Assert.assertEquals((long)0L, (long)buffer.get());
        Assert.assertEquals((long)2L, (long)buffer.get());
        Assert.assertEquals((long)0L, (long)buffer.get());
        buffer.clear();
        buffer.limit(8);
        channel.read(buffer, 15L);
        buffer.flip();
        Assert.assertEquals((long)longValue, (long)buffer.getLong());
        fs.close();
    }

    @Test
    public void absoluteVersusRelative() throws Exception {
        File file = new File("myfile");
        EphemeralFileSystemAbstraction fs = (EphemeralFileSystemAbstraction)this.fileSystemRule.get();
        StoreChannel channel = fs.open(file, "rw");
        byte[] bytes = "test".getBytes();
        channel.write(ByteBuffer.wrap(bytes));
        channel.close();
        channel = fs.open(new File(file.getAbsolutePath()), "r");
        byte[] readBytes = new byte[bytes.length];
        int nrOfReadBytes = channel.read(ByteBuffer.wrap(readBytes));
        Assert.assertEquals((long)bytes.length, (long)nrOfReadBytes);
        Assert.assertTrue((boolean)Arrays.equals(bytes, readBytes));
        fs.close();
    }

    @Test
    public void listFiles() throws Exception {
        EphemeralFileSystemAbstraction fs = (EphemeralFileSystemAbstraction)this.fileSystemRule.get();
        File root = new File("/root").getCanonicalFile();
        File dir1 = new File(root, "dir1");
        File dir2 = new File(root, "dir2");
        File subdir1 = new File(dir1, "sub");
        File file1 = new File(dir1, "file");
        File file2 = new File(dir1, "file2");
        File file3 = new File(dir2, "file");
        File file4 = new File(subdir1, "file");
        fs.mkdirs(dir2);
        fs.mkdirs(dir1);
        fs.mkdirs(subdir1);
        fs.create(file1);
        fs.create(file2);
        fs.create(file3);
        fs.create(file4);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new File[]{dir1, dir2}), (Object)Iterators.asSet((Object[])fs.listFiles(root)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new File[]{subdir1, file1, file2}), (Object)Iterators.asSet((Object[])fs.listFiles(dir1)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new File[]{file3}), (Object)Iterators.asSet((Object[])fs.listFiles(dir2)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new File[]{file4}), (Object)Iterators.asSet((Object[])fs.listFiles(subdir1)));
        fs.close();
    }
}

