/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.collection.primitive.PrimitiveIntCollection;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.legacyindex.AutoIndexingKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;

public class GuardingStatementOperations
implements EntityWriteOperations,
EntityReadOperations {
    private final EntityWriteOperations entityWriteDelegate;
    private final EntityReadOperations entityReadDelegate;
    private final Guard guard;

    public GuardingStatementOperations(EntityWriteOperations entityWriteDelegate, EntityReadOperations entityReadDelegate, Guard guard) {
        this.entityWriteDelegate = entityWriteDelegate;
        this.entityReadDelegate = entityReadDelegate;
        this.guard = guard;
    }

    @Override
    public long relationshipCreate(KernelStatement statement, int relationshipTypeId, long startNodeId, long endNodeId) throws EntityNotFoundException {
        this.guard.check(statement);
        return this.entityWriteDelegate.relationshipCreate(statement, relationshipTypeId, startNodeId, endNodeId);
    }

    @Override
    public long nodeCreate(KernelStatement statement) {
        this.guard.check(statement);
        return this.entityWriteDelegate.nodeCreate(statement);
    }

    @Override
    public void nodeDelete(KernelStatement statement, long nodeId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.guard.check(statement);
        this.entityWriteDelegate.nodeDelete(statement, nodeId);
    }

    @Override
    public void relationshipDelete(KernelStatement statement, long relationshipId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.guard.check(statement);
        this.entityWriteDelegate.relationshipDelete(statement, relationshipId);
    }

    @Override
    public int nodeDetachDelete(KernelStatement statement, long nodeId) throws KernelException {
        this.guard.check(statement);
        return this.entityWriteDelegate.nodeDetachDelete(statement, nodeId);
    }

    @Override
    public boolean nodeAddLabel(KernelStatement statement, long nodeId, int labelId) throws ConstraintValidationException, EntityNotFoundException {
        this.guard.check(statement);
        return this.entityWriteDelegate.nodeAddLabel(statement, nodeId, labelId);
    }

    @Override
    public boolean nodeRemoveLabel(KernelStatement statement, long nodeId, int labelId) throws EntityNotFoundException {
        this.guard.check(statement);
        return this.entityWriteDelegate.nodeRemoveLabel(statement, nodeId, labelId);
    }

    @Override
    public Property nodeSetProperty(KernelStatement statement, long nodeId, DefinedProperty property) throws ConstraintValidationException, EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.guard.check(statement);
        return this.entityWriteDelegate.nodeSetProperty(statement, nodeId, property);
    }

    @Override
    public Property relationshipSetProperty(KernelStatement statement, long relationshipId, DefinedProperty property) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.guard.check(statement);
        return this.entityWriteDelegate.relationshipSetProperty(statement, relationshipId, property);
    }

    @Override
    public Property graphSetProperty(KernelStatement statement, DefinedProperty property) {
        this.guard.check(statement);
        return this.entityWriteDelegate.graphSetProperty(statement, property);
    }

    @Override
    public Property nodeRemoveProperty(KernelStatement statement, long nodeId, int propertyKeyId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.guard.check(statement);
        return this.entityWriteDelegate.nodeRemoveProperty(statement, nodeId, propertyKeyId);
    }

    @Override
    public Property relationshipRemoveProperty(KernelStatement statement, long relationshipId, int propertyKeyId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.guard.check(statement);
        return this.entityWriteDelegate.relationshipRemoveProperty(statement, relationshipId, propertyKeyId);
    }

    @Override
    public Property graphRemoveProperty(KernelStatement statement, int propertyKeyId) {
        this.guard.check(statement);
        return this.entityWriteDelegate.graphRemoveProperty(statement, propertyKeyId);
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(KernelStatement statement, int labelId) {
        this.guard.check(statement);
        return this.entityReadDelegate.nodesGetForLabel(statement, labelId);
    }

    @Override
    public PrimitiveLongIterator indexQuery(KernelStatement statement, IndexDescriptor index, IndexQuery[] predicates) throws IndexNotFoundKernelException, IndexNotApplicableKernelException {
        this.guard.check(statement);
        return this.entityReadDelegate.indexQuery(statement, index, predicates);
    }

    @Override
    public long nodeGetFromUniqueIndexSeek(KernelStatement statement, IndexDescriptor index, IndexQuery.ExactPredicate ... predicates) throws IndexNotFoundKernelException, IndexBrokenKernelException, IndexNotApplicableKernelException {
        this.guard.check(statement);
        return this.entityReadDelegate.nodeGetFromUniqueIndexSeek(statement, index, predicates);
    }

    @Override
    public long nodesCountIndexed(KernelStatement statement, IndexDescriptor index, long nodeId, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        this.guard.check(statement);
        return this.entityReadDelegate.nodesCountIndexed(statement, index, nodeId, value);
    }

    @Override
    public boolean graphHasProperty(KernelStatement statement, int propertyKeyId) {
        this.guard.check(statement);
        return this.entityReadDelegate.graphHasProperty(statement, propertyKeyId);
    }

    @Override
    public Object graphGetProperty(KernelStatement statement, int propertyKeyId) {
        this.guard.check(statement);
        return this.entityReadDelegate.graphGetProperty(statement, propertyKeyId);
    }

    @Override
    public PrimitiveIntIterator graphGetPropertyKeys(KernelStatement statement) {
        this.guard.check(statement);
        return this.entityReadDelegate.graphGetPropertyKeys(statement);
    }

    @Override
    public PrimitiveLongIterator nodesGetAll(KernelStatement statement) {
        this.guard.check(statement);
        return this.entityReadDelegate.nodesGetAll(statement);
    }

    @Override
    public PrimitiveLongIterator relationshipsGetAll(KernelStatement statement) {
        this.guard.check(statement);
        return this.entityReadDelegate.relationshipsGetAll(statement);
    }

    @Override
    public <EXCEPTION extends Exception> void relationshipVisit(KernelStatement statement, long relId, RelationshipVisitor<EXCEPTION> visitor) throws EntityNotFoundException, EXCEPTION {
        this.guard.check(statement);
        this.entityReadDelegate.relationshipVisit(statement, relId, visitor);
    }

    @Override
    public Cursor<NodeItem> nodeCursorById(KernelStatement statement, long nodeId) throws EntityNotFoundException {
        this.guard.check(statement);
        return this.entityReadDelegate.nodeCursorById(statement, nodeId);
    }

    @Override
    public Cursor<RelationshipItem> relationshipCursorById(KernelStatement statement, long relId) throws EntityNotFoundException {
        this.guard.check(statement);
        return this.entityReadDelegate.relationshipCursorById(statement, relId);
    }

    @Override
    public Cursor<RelationshipItem> relationshipCursorGetAll(KernelStatement statement) {
        this.guard.check(statement);
        return this.entityReadDelegate.relationshipCursorGetAll(statement);
    }

    @Override
    public Cursor<RelationshipItem> nodeGetRelationships(KernelStatement statement, NodeItem node, Direction direction) {
        this.guard.check(statement);
        return this.entityReadDelegate.nodeGetRelationships(statement, node, direction);
    }

    @Override
    public Cursor<RelationshipItem> nodeGetRelationships(KernelStatement statement, NodeItem node, Direction direction, int[] relTypes) {
        this.guard.check(statement);
        return this.entityReadDelegate.nodeGetRelationships(statement, node, direction, relTypes);
    }

    @Override
    public Cursor<PropertyItem> nodeGetProperties(KernelStatement statement, NodeItem node) {
        this.guard.check(statement);
        return this.entityReadDelegate.nodeGetProperties(statement, node);
    }

    @Override
    public Object nodeGetProperty(KernelStatement statement, NodeItem node, int propertyKeyId) {
        this.guard.check(statement);
        return this.entityReadDelegate.nodeGetProperty(statement, node, propertyKeyId);
    }

    @Override
    public boolean nodeHasProperty(KernelStatement statement, NodeItem node, int propertyKeyId) {
        this.guard.check(statement);
        return this.entityReadDelegate.nodeHasProperty(statement, node, propertyKeyId);
    }

    @Override
    public PrimitiveIntCollection nodeGetPropertyKeys(KernelStatement statement, NodeItem node) {
        this.guard.check(statement);
        return this.entityReadDelegate.nodeGetPropertyKeys(statement, node);
    }

    @Override
    public Cursor<PropertyItem> relationshipGetProperties(KernelStatement statement, RelationshipItem relationship) {
        this.guard.check(statement);
        return this.entityReadDelegate.relationshipGetProperties(statement, relationship);
    }

    @Override
    public Object relationshipGetProperty(KernelStatement statement, RelationshipItem relationship, int propertyKeyId) {
        this.guard.check(statement);
        return this.entityReadDelegate.relationshipGetProperty(statement, relationship, propertyKeyId);
    }

    @Override
    public boolean relationshipHasProperty(KernelStatement statement, RelationshipItem relationship, int propertyKeyId) {
        this.guard.check(statement);
        return this.entityReadDelegate.relationshipHasProperty(statement, relationship, propertyKeyId);
    }

    @Override
    public PrimitiveIntCollection relationshipGetPropertyKeys(KernelStatement statement, RelationshipItem relationship) {
        this.guard.check(statement);
        return this.entityReadDelegate.relationshipGetPropertyKeys(statement, relationship);
    }

    @Override
    public long nodesGetCount(KernelStatement statement) {
        this.guard.check(statement);
        return this.entityReadDelegate.nodesGetCount(statement);
    }

    @Override
    public long relationshipsGetCount(KernelStatement statement) {
        this.guard.check(statement);
        return this.entityReadDelegate.relationshipsGetCount(statement);
    }

    @Override
    public boolean nodeExists(KernelStatement statement, long id) {
        this.guard.check(statement);
        return this.entityReadDelegate.nodeExists(statement, id);
    }

    @Override
    public PrimitiveIntSet relationshipTypes(KernelStatement statement, NodeItem nodeItem) {
        this.guard.check(statement);
        return this.entityReadDelegate.relationshipTypes(statement, nodeItem);
    }

    @Override
    public int degree(KernelStatement statement, NodeItem nodeItem, Direction direction) {
        this.guard.check(statement);
        return this.entityReadDelegate.degree(statement, nodeItem, direction);
    }

    @Override
    public int degree(KernelStatement statement, NodeItem nodeItem, Direction direction, int relType) {
        this.guard.check(statement);
        return this.entityReadDelegate.degree(statement, nodeItem, direction, relType);
    }
}

