/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.impl.transaction.TransactionStats;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.time.Clocks;

public class DatabaseAvailability
implements Lifecycle {
    private static final AvailabilityGuard.AvailabilityRequirement AVAILABILITY_REQUIREMENT = AvailabilityGuard.availabilityRequirement("Database available");
    private final AvailabilityGuard availabilityGuard;
    private final TransactionStats transactionMonitor;
    private final long awaitActiveTransactionDeadlineMillis;

    public DatabaseAvailability(AvailabilityGuard availabilityGuard, TransactionStats transactionMonitor, long awaitActiveTransactionDeadlineMillis) {
        this.availabilityGuard = availabilityGuard;
        this.transactionMonitor = transactionMonitor;
        this.awaitActiveTransactionDeadlineMillis = awaitActiveTransactionDeadlineMillis;
        availabilityGuard.require(AVAILABILITY_REQUIREMENT);
    }

    public void init() throws Throwable {
    }

    public void start() throws Throwable {
        this.availabilityGuard.fulfill(AVAILABILITY_REQUIREMENT);
    }

    public void stop() throws Throwable {
        this.availabilityGuard.require(AVAILABILITY_REQUIREMENT);
        this.awaitTransactionsClosedWithinTimeout();
    }

    private void awaitTransactionsClosedWithinTimeout() {
        Clock clock = Clocks.systemClock();
        long deadline = clock.millis() + this.awaitActiveTransactionDeadlineMillis;
        while (this.transactionMonitor.getNumberOfActiveTransactions() > 0L && clock.millis() < deadline) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
    }

    public void shutdown() throws Throwable {
    }
}

