/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeToken;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.storageengine.api.Token;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class BridgingCacheAccess
implements CacheAccessBackDoor {
    private final SchemaCache schemaCache;
    private final Runnable schemaStateChangeCallback;
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final RelationshipTypeTokenHolder relationshipTypeTokenHolder;
    private final LabelTokenHolder labelTokenHolder;

    public BridgingCacheAccess(SchemaCache schemaCache, Runnable schemaStateChangeCallback, PropertyKeyTokenHolder propertyKeyTokenHolder, RelationshipTypeTokenHolder relationshipTypeTokenHolder, LabelTokenHolder labelTokenHolder) {
        this.schemaCache = schemaCache;
        this.schemaStateChangeCallback = schemaStateChangeCallback;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.relationshipTypeTokenHolder = relationshipTypeTokenHolder;
        this.labelTokenHolder = labelTokenHolder;
    }

    @Override
    public void addSchemaRule(SchemaRule rule) {
        this.schemaCache.addSchemaRule(rule);
    }

    @Override
    public void removeSchemaRuleFromCache(long id) {
        this.schemaCache.removeSchemaRule(id);
        this.schemaStateChangeCallback.run();
    }

    @Override
    public void addRelationshipTypeToken(RelationshipTypeToken type) {
        this.relationshipTypeTokenHolder.addToken(type);
    }

    @Override
    public void addLabelToken(Token label) {
        this.labelTokenHolder.addToken(label);
    }

    @Override
    public void addPropertyKeyToken(Token propertyKey) {
        this.propertyKeyTokenHolder.addToken(propertyKey);
    }
}

