/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Connector;
import org.neo4j.kernel.configuration.ConnectorValidator;
import org.neo4j.kernel.configuration.Settings;

public class BoltConnectorValidator
extends ConnectorValidator {
    public BoltConnectorValidator() {
        super(Connector.ConnectorType.BOLT);
    }

    @Override
    @Nonnull
    protected Optional<Setting<Object>> getSettingFor(@Nonnull String settingName, @Nonnull Map<String, String> params) {
        Object setting;
        String subsetting;
        String[] parts = settingName.split("\\.");
        String name = parts[2];
        switch (subsetting = parts[3]) {
            case "enabled": {
                setting = Settings.setting(settingName, Settings.BOOLEAN, "false");
                setting.setDescription("Enable this connector.");
                break;
            }
            case "type": {
                setting = Settings.setting(settingName, Settings.options(Connector.ConnectorType.class), Settings.NO_DEFAULT);
                setting.setDeprecated(true);
                setting.setDescription("Connector type. This setting is deprecated and its value will instead be inferred from the name of the connector.");
                break;
            }
            case "tls_level": {
                setting = Settings.setting(settingName, Settings.options(BoltConnector.EncryptionLevel.class), BoltConnector.EncryptionLevel.OPTIONAL.name());
                setting.setDescription("Encryption level to require this connector to use.");
                break;
            }
            case "address": {
                setting = Settings.listenAddress(settingName, 7687);
                setting.setDeprecated(true);
                setting.setReplacement("dbms.connector." + name + ".listen_address");
                setting.setDescription("Address the connector should bind to. Deprecated and replaced by " + setting.replacement().get() + ".");
                break;
            }
            case "listen_address": {
                setting = Settings.listenAddress(settingName, 7687);
                setting.setDescription("Address the connector should bind to.");
                break;
            }
            case "advertised_address": {
                setting = Settings.advertisedAddress(settingName, Settings.listenAddress(settingName, 7687));
                setting.setDescription("Advertised address for this connector.");
                break;
            }
            default: {
                return Optional.empty();
            }
        }
        if (this.isDeprecatedConnectorName(name) && !setting.deprecated()) {
            setting.setDeprecated(true);
            setting.setReplacement(String.format("%s.%s.%s.%s", parts[0], parts[1], "bolt", subsetting));
        }
        return Optional.of(setting);
    }
}

