/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.File;
import java.util.stream.LongStream;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;

public class ThresholdBasedPruneStrategy
implements LogPruneStrategy {
    private final FileSystemAbstraction fileSystem;
    private final LogFileInformation logFileInformation;
    private final PhysicalLogFiles files;
    private final Threshold threshold;

    public ThresholdBasedPruneStrategy(FileSystemAbstraction fileSystem, LogFileInformation logFileInformation, PhysicalLogFiles files, Threshold threshold) {
        this.fileSystem = fileSystem;
        this.logFileInformation = logFileInformation;
        this.files = files;
        this.threshold = threshold;
    }

    @Override
    public synchronized LongStream findLogVersionsToDelete(long upToLogVersion) {
        long upper;
        if (upToLogVersion == 0L) {
            return LongStream.empty();
        }
        this.threshold.init();
        boolean exceeded = false;
        for (upper = upToLogVersion - 1L; upper >= 0L; --upper) {
            File file = this.files.getLogFileForVersion(upper);
            if (!this.fileSystem.fileExists(file)) {
                return LongStream.empty();
            }
            if (this.fileSystem.getFileSize(file) <= 16L || !this.threshold.reached(file, upper, this.logFileInformation)) continue;
            exceeded = true;
            break;
        }
        if (!exceeded) {
            return LongStream.empty();
        }
        long lower = upper;
        while (this.fileSystem.fileExists(this.files.getLogFileForVersion(lower - 1L))) {
            --lower;
        }
        if (upper == upToLogVersion - 1L) {
            --upper;
        }
        return LongStream.rangeClosed(lower, upper);
    }
}

