/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaUtil;

public class DropIndexFailureException
extends SchemaKernelException {
    private final LabelSchemaDescriptor descriptor;
    private static final String message = "Unable to drop index on %s: %s";

    public DropIndexFailureException(LabelSchemaDescriptor descriptor, SchemaKernelException cause) {
        super((Status)Status.Schema.IndexDropFailed, String.format(message, descriptor.userDescription(SchemaUtil.idTokenNameLookup), cause.getMessage()), cause);
        this.descriptor = descriptor;
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format(message, this.descriptor.userDescription(tokenNameLookup), ((KernelException)this.getCause()).getUserMessage(tokenNameLookup));
    }
}

