/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.io.OutputStream;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.logging.FormattedLogProvider;

public final class ConfigurableStandalonePageCacheFactory {
    private ConfigurableStandalonePageCacheFactory() {
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem) {
        return ConfigurableStandalonePageCacheFactory.createPageCache(fileSystem, PageCacheTracer.NULL, (PageCursorTracerSupplier)DefaultPageCursorTracerSupplier.INSTANCE, Config.defaults());
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, Config config) {
        return ConfigurableStandalonePageCacheFactory.createPageCache(fileSystem, PageCacheTracer.NULL, (PageCursorTracerSupplier)DefaultPageCursorTracerSupplier.INSTANCE, config);
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, PageCacheTracer pageCacheTracer, PageCursorTracerSupplier pageCursorTracerSupplier, Config config) {
        Config finalConfig = config.withDefaults(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), "8M"}));
        FormattedLogProvider logProvider = FormattedLogProvider.toOutputStream((OutputStream)System.err);
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fileSystem, finalConfig, pageCacheTracer, pageCursorTracerSupplier, logProvider.getLog(PageCache.class));
        return pageCacheFactory.getOrCreatePageCache();
    }
}

