/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.labelscan.LabelScanKey;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValue;

class LabelScanLayout
extends Layout.Adapter<LabelScanKey, LabelScanValue> {
    private static final String IDENTIFIER_NAME = "LSL";
    private static final int KEY_SIZE = 10;

    LabelScanLayout() {
    }

    public int compare(LabelScanKey o1, LabelScanKey o2) {
        int labelComparison = Integer.compare(o1.labelId, o2.labelId);
        return labelComparison != 0 ? labelComparison : Long.compare(o1.idRange, o2.idRange);
    }

    public LabelScanKey newKey() {
        return new LabelScanKey();
    }

    public LabelScanKey copyKey(LabelScanKey key, LabelScanKey into) {
        into.labelId = key.labelId;
        into.idRange = key.idRange;
        return into;
    }

    public LabelScanValue newValue() {
        return new LabelScanValue();
    }

    public int keySize() {
        return 10;
    }

    public int valueSize() {
        return 8;
    }

    public void writeKey(PageCursor cursor, LabelScanKey key) {
        cursor.putInt(key.labelId);
        LabelScanLayout.put6ByteLong(cursor, key.idRange);
    }

    private static void put6ByteLong(PageCursor cursor, long value) {
        cursor.putInt((int)value);
        cursor.putShort((short)(value >>> 32));
    }

    public void writeValue(PageCursor cursor, LabelScanValue value) {
        cursor.putLong(value.bits);
    }

    public void readKey(PageCursor cursor, LabelScanKey into) {
        into.labelId = cursor.getInt();
        into.idRange = LabelScanLayout.get6ByteLong(cursor);
    }

    private static long get6ByteLong(PageCursor cursor) {
        long low4b = (long)cursor.getInt() & 0xFFFFFFFFL;
        long high2b = cursor.getShort();
        return low4b | high2b << 32;
    }

    public void readValue(PageCursor cursor, LabelScanValue into) {
        into.bits = cursor.getLong();
    }

    public long identifier() {
        return Layout.namedIdentifier((String)IDENTIFIER_NAME, (int)64);
    }

    public int majorVersion() {
        return 0;
    }

    public int minorVersion() {
        return 1;
    }
}

