/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.format.FormatFamily;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.recovery.LatestCheckPointFinder;

public class UpgradableDatabase {
    private final FileSystemAbstraction fs;
    private final StoreVersionCheck storeVersionCheck;
    private final RecordFormats format;

    public UpgradableDatabase(FileSystemAbstraction fs, StoreVersionCheck storeVersionCheck, RecordFormats format) {
        this.fs = fs;
        this.storeVersionCheck = storeVersionCheck;
        this.format = format;
    }

    public RecordFormats checkUpgradeable(File storeDirectory) {
        StoreVersionCheck.Result result = this.storeVersionCheck.hasVersion(new File(storeDirectory, "neostore"), this.format.storeVersion());
        if (result.outcome.isSuccessful()) {
            return this.format;
        }
        try {
            RecordFormats fromFormat = RecordFormatSelector.selectForVersion(result.actualVersion);
            if (FormatFamily.isLowerFamilyFormat(this.format, fromFormat)) {
                throw new StoreUpgrader.UnexpectedUpgradingStoreFormatException();
            }
            if (FormatFamily.isSameFamily(fromFormat, this.format) && fromFormat.generation() > this.format.generation()) {
                result = new StoreVersionCheck.Result(StoreVersionCheck.Result.Outcome.attemptedStoreDowngrade, fromFormat.storeVersion(), new File(storeDirectory, "neostore").getAbsolutePath());
            } else {
                result = this.checkCleanShutDownByCheckPoint(storeDirectory);
                if (result.outcome.isSuccessful()) {
                    return fromFormat;
                }
            }
        }
        catch (IllegalArgumentException e) {
            result = new StoreVersionCheck.Result(StoreVersionCheck.Result.Outcome.unexpectedStoreVersion, result.actualVersion, result.storeFilename);
        }
        switch (result.outcome) {
            case missingStoreFile: {
                throw new StoreUpgrader.UpgradeMissingStoreFilesException(this.getPathToStoreFile(storeDirectory, result));
            }
            case storeVersionNotFound: {
                throw new StoreUpgrader.UpgradingStoreVersionNotFoundException(this.getPathToStoreFile(storeDirectory, result));
            }
            case attemptedStoreDowngrade: {
                throw new StoreUpgrader.AttemptedDowngradeException();
            }
            case unexpectedStoreVersion: {
                throw new StoreUpgrader.UnexpectedUpgradingStoreVersionException(result.actualVersion, this.format.storeVersion());
            }
            case storeNotCleanlyShutDown: {
                throw new StoreUpgrader.DatabaseNotCleanlyShutDownException();
            }
        }
        throw new IllegalArgumentException("Unexpected outcome: " + result.outcome.name());
    }

    private StoreVersionCheck.Result checkCleanShutDownByCheckPoint(File storeDirectory) {
        PhysicalLogFiles logFiles = new PhysicalLogFiles(storeDirectory, this.fs);
        VersionAwareLogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader = new VersionAwareLogEntryReader<ReadableClosablePositionAwareChannel>();
        LatestCheckPointFinder latestCheckPointFinder = new LatestCheckPointFinder(logFiles, this.fs, logEntryReader);
        try {
            LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = latestCheckPointFinder.find(logFiles.getHighestLogVersion());
            if (!latestCheckPoint.commitsAfterCheckPoint) {
                return new StoreVersionCheck.Result(StoreVersionCheck.Result.Outcome.ok, null, null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new StoreVersionCheck.Result(StoreVersionCheck.Result.Outcome.storeNotCleanlyShutDown, null, null);
    }

    private String getPathToStoreFile(File storeDirectory, StoreVersionCheck.Result result) {
        return new File(storeDirectory, result.storeFilename).getAbsolutePath();
    }

    boolean hasCurrentVersion(File storeDir) {
        File neoStore = new File(storeDir, "neostore");
        StoreVersionCheck.Result result = this.storeVersionCheck.hasVersion(neoStore, this.format.storeVersion());
        switch (result.outcome) {
            case missingStoreFile: 
            case ok: {
                return true;
            }
            case storeVersionNotFound: 
            case attemptedStoreDowngrade: 
            case unexpectedStoreVersion: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown outcome: " + result.outcome.name());
    }

    public String currentVersion() {
        return this.format.storeVersion();
    }
}

