/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class VersionedHashMap<K, V>
implements Map<K, V> {
    private static final int MAX_BUCKETS = 0x40000000;
    private Record<K, V>[] buckets;
    private int size;
    private int version;
    private short liveIterators;
    private int bitwiseModByBuckets;
    private int resizeThreshold;
    private float resizeAtCapacity;
    private final EntrySet entrySet = new EntrySet();
    private final KeySet keys = new KeySet();
    private final ValueCollection values = new ValueCollection();

    public VersionedHashMap() {
        this(16, 0.85f);
    }

    public VersionedHashMap(int numBuckets, float resizeAtCapacity) {
        if (Integer.bitCount(numBuckets) != 1) {
            throw new UnsupportedOperationException("Number of buckets must be a power-of-2 number, 2,4,8,16 etc.");
        }
        this.resizeAtCapacity = resizeAtCapacity;
        this.buckets = new Record[numBuckets];
        this.bitwiseModByBuckets = numBuckets - 1;
        this.resizeThreshold = (int)((float)numBuckets * resizeAtCapacity);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getRecord(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Record<K, V> bucket : this.buckets) {
            while (bucket != null) {
                if (bucket.value == value || bucket.value.equals(value)) {
                    return true;
                }
                bucket = bucket.next;
            }
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Record<K, V> record = this.getRecord(key);
        if (record != null) {
            return record.value;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        int hash = VersionedHashMap.hash(key.hashCode());
        int bucket = hash & this.bitwiseModByBuckets;
        Record<K, V> record = this.buckets[bucket];
        while (record != null) {
            if (record.hashCode == hash && (record.key == key || record.key.equals(key))) {
                Object old = record.value;
                record.value = value;
                return old;
            }
            record = record.next;
        }
        this.buckets[bucket] = record = new Record<K, V>(hash, key, value, this.buckets[bucket], this.version);
        if (this.size++ > this.resizeThreshold) {
            this.resize(this.buckets.length << 1);
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        int hash = VersionedHashMap.hash(key.hashCode());
        int bucket = hash & this.bitwiseModByBuckets;
        Record<K, V> prev = null;
        Record<K, V> record = this.buckets[bucket];
        while (record != null) {
            if (record.hashCode == hash && (record.key == key || record.key.equals(key))) {
                Object old = record.value;
                if (prev == null) {
                    this.buckets[bucket] = record.next;
                } else {
                    prev.next = record.next;
                }
                record.remove();
                --this.size;
                return old;
            }
            prev = record;
            record = record.next;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void clear() {
        this.size = 0;
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = null;
        }
    }

    @Override
    public Set<K> keySet() {
        return this.keys;
    }

    @Override
    public Collection<V> values() {
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    private Record<K, V> getRecord(Object key) {
        int hash = VersionedHashMap.hash(key.hashCode());
        int bucket = hash & this.bitwiseModByBuckets;
        Record<K, V> record = this.buckets[bucket];
        while (record != null) {
            if (record.key.equals(key)) {
                return record;
            }
            record = record.next;
        }
        return null;
    }

    private void resize(int numBuckets) {
        if (numBuckets >= 0x40000000) {
            this.resizeThreshold = Integer.MAX_VALUE;
            return;
        }
        Record<K, V>[] oldBuckets = this.buckets;
        this.buckets = new Record[numBuckets];
        this.bitwiseModByBuckets = numBuckets - 1;
        this.resizeThreshold = (int)((float)numBuckets * this.resizeAtCapacity);
        for (Record record : oldBuckets) {
            while (record != null) {
                Record next = record.next;
                if (next != null && this.liveIterators > 0) {
                    record = record.copy();
                } else if (this.liveIterators == 0 && record instanceof CopiedRecord) {
                    record = ((CopiedRecord)record).original;
                }
                int bucket = record.hashCode & this.bitwiseModByBuckets;
                record.next = this.buckets[bucket];
                this.buckets[bucket] = record;
                record = next;
            }
        }
    }

    private static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static /* synthetic */ short access$1108(VersionedHashMap x0) {
        short s = x0.liveIterators;
        x0.liveIterators = (short)(s + 1);
        return s;
    }

    static /* synthetic */ short access$1110(VersionedHashMap x0) {
        short s = x0.liveIterators;
        x0.liveIterators = (short)(s - 1);
        return s;
    }

    private static class CopiedRecord<K, V>
    extends Record<K, V> {
        private Record<K, V> original;

        CopiedRecord(Record<K, V> original, int hashCode, K key, V value, Record<K, V> next, int addedInVersion) {
            super(hashCode, key, value, next, addedInVersion);
            this.original = original;
        }

        @Override
        public void remove() {
            this.removed = true;
            this.original.remove();
        }

        @Override
        public String toString() {
            return "CopiedRecord{hashCode=" + this.hashCode + ", key=" + this.key + ", value=" + this.value + ", next=" + (this.next == null ? "null + " : this.next.key) + ", addedInVersion=" + this.addedInVersion + ", removed=" + this.removed + ", original=" + this.original + '}';
        }
    }

    private static class Record<K, V>
    implements Map.Entry<K, V> {
        protected int hashCode;
        protected K key;
        protected V value;
        protected Record<K, V> next;
        protected int addedInVersion;
        protected boolean removed;

        Record(int hashCode, K key, V value, Record<K, V> next, int addedInVersion) {
            this.hashCode = hashCode;
            this.key = key;
            this.value = value;
            this.next = next;
            this.addedInVersion = addedInVersion;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V old = this.value;
            this.value = value;
            return old;
        }

        public void remove() {
            this.removed = true;
        }

        public Record<K, V> copy() {
            if (!this.removed) {
                return new CopiedRecord<K, V>(this, this.hashCode, this.key, this.value, this.next, this.addedInVersion);
            }
            return new Record<K, V>(this.hashCode, this.key, this.value, this.next, this.addedInVersion);
        }

        public String toString() {
            return "Record{hashCode=" + this.hashCode + ", key=" + this.key + ", value=" + this.value + ", next=" + (this.next == null ? "null + " : this.next.key) + ", addedInVersion=" + this.addedInVersion + ", removed=" + this.removed + '}';
        }
    }

    private class ValueIterator
    implements Iterator<V> {
        private final Iterator<Map.Entry<K, V>> entryIterator;

        private ValueIterator(Iterator<Map.Entry<K, V>> entryIterator) {
            this.entryIterator = entryIterator;
        }

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext();
        }

        @Override
        public V next() {
            return this.entryIterator.next().getValue();
        }

        @Override
        public void remove() {
            this.entryIterator.remove();
        }
    }

    private class KeyIterator
    implements Iterator<K> {
        private final Iterator<Map.Entry<K, V>> entryIterator;

        private KeyIterator(Iterator<Map.Entry<K, V>> entryIterator) {
            this.entryIterator = entryIterator;
        }

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext();
        }

        @Override
        public K next() {
            return this.entryIterator.next().getKey();
        }

        @Override
        public void remove() {
            this.entryIterator.remove();
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private int viewVersion;
        private int currentBucket;
        private Record<K, V> next;
        private Record<K, V> current;
        private Record<K, V>[] bucketsView;
        private boolean exhausted;

        private EntryIterator() {
            this.bucketsView = VersionedHashMap.this.buckets;
            this.viewVersion = VersionedHashMap.this.version;
            VersionedHashMap.this.version++;
            VersionedHashMap.access$1108(VersionedHashMap.this);
            while (this.next == null && this.currentBucket < this.bucketsView.length) {
                this.next = this.bucketsView[this.currentBucket];
                ++this.currentBucket;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.exhausted) {
                return false;
            }
            if (this.next != null && this.next.removed) {
                this.next();
            }
            if (this.next != null) {
                return true;
            }
            this.exhausted = true;
            VersionedHashMap.access$1110(VersionedHashMap.this);
            return false;
        }

        @Override
        public Record<K, V> next() {
            this.current = this.next;
            this.next = this.next.next;
            if (this.next == null || this.next.addedInVersion > this.viewVersion || this.next.removed) {
                while ((this.next == null || this.next.addedInVersion > this.viewVersion || this.next.removed) && this.currentBucket < this.bucketsView.length) {
                    this.next = this.bucketsView[this.currentBucket];
                    while (this.next != null && (this.next.addedInVersion > this.viewVersion || this.next.removed)) {
                        this.next = this.next.next;
                    }
                    ++this.currentBucket;
                }
            }
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException("Not currently on a record. Did you call next()?");
            }
            VersionedHashMap.this.remove(this.current.key);
        }
    }

    private class ValueCollection
    extends AbstractCollection<V> {
        private ValueCollection() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(VersionedHashMap.this.entrySet.iterator());
        }

        @Override
        public int size() {
            return VersionedHashMap.this.size;
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator(VersionedHashMap.this.entrySet.iterator());
        }

        @Override
        public int size() {
            return VersionedHashMap.this.size;
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean add(Map.Entry<K, V> kvEntry) {
            return VersionedHashMap.this.put(kvEntry.getKey(), kvEntry.getValue()) != null;
        }

        @Override
        public int size() {
            return VersionedHashMap.this.size;
        }
    }
}

