/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import org.neo4j.function.Suppliers;
import org.neo4j.helpers.FutureAdapter;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public class IndexPopulationJob
implements Runnable {
    private final IndexingService.Monitor monitor;
    private final MultipleIndexPopulator multiPopulator;
    private final CountDownLatch doneSignal = new CountDownLatch(1);
    private final SchemaState schemaState;
    private volatile StoreScan<IndexPopulationFailedKernelException> storeScan;
    private volatile boolean cancelled;

    public IndexPopulationJob(MultipleIndexPopulator multiPopulator, IndexingService.Monitor monitor, SchemaState schemaState) {
        this.multiPopulator = multiPopulator;
        this.schemaState = schemaState;
        this.monitor = monitor;
    }

    public void addPopulator(IndexPopulator populator, long indexId, IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, String indexUserDescription, FlippableIndexProxy flipper, FailedIndexProxyFactory failedIndexProxyFactory) {
        assert (this.storeScan == null) : "Population have already started, too late to add populators at this point";
        this.multiPopulator.addPopulator(populator, indexId, descriptor, providerDescriptor, flipper, failedIndexProxyFactory, indexUserDescription);
    }

    @Override
    public void run() {
        String oldThreadName;
        block8: {
            assert (this.multiPopulator.hasPopulators()) : "No index populators was added so there'd be no point in running this job";
            assert (this.storeScan == null) : "Population have already started";
            oldThreadName = Thread.currentThread().getName();
            Thread.currentThread().setName("Index populator");
            this.multiPopulator.create();
            this.multiPopulator.replaceIndexCounts(0L, 0L, 0L);
            this.indexAllNodes();
            this.monitor.indexPopulationScanComplete();
            if (!this.cancelled) break block8;
            this.multiPopulator.cancel();
            this.doneSignal.countDown();
            Thread.currentThread().setName(oldThreadName);
            return;
        }
        try {
            try {
                this.multiPopulator.flipAfterPopulation();
                this.schemaState.clear();
            }
            catch (Throwable t) {
                this.multiPopulator.fail(t);
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.doneSignal.countDown();
            Thread.currentThread().setName(oldThreadName);
        }
    }

    private void indexAllNodes() throws IndexPopulationFailedKernelException {
        this.storeScan = this.multiPopulator.indexAllNodes();
        this.storeScan.run();
    }

    public PopulationProgress getPopulationProgress() {
        if (this.storeScan == null) {
            return PopulationProgress.NONE;
        }
        return this.storeScan.getProgress();
    }

    public Future<Void> cancel() {
        if (this.storeScan != null) {
            this.cancelled = true;
            this.storeScan.stop();
        }
        return FutureAdapter.latchGuardedValue(Suppliers.singleton(null), this.doneSignal, "Index population job cancel");
    }

    public void update(IndexEntryUpdate update) {
        this.multiPopulator.queue(update);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[populator:" + this.multiPopulator + "]";
    }

    public void awaitCompletion() throws InterruptedException {
        this.doneSignal.await();
    }
}

