/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorPredicates;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class SchemaCache {
    private final Map<Long, IndexRule> indexRuleById = new HashMap<Long, IndexRule>();
    private final Map<Long, ConstraintRule> constraintRuleById = new HashMap<Long, ConstraintRule>();
    private final Set<ConstraintDescriptor> constraints = new HashSet<ConstraintDescriptor>();
    private final Map<SchemaDescriptor, IndexDescriptor> indexDescriptors = new HashMap<SchemaDescriptor, IndexDescriptor>();
    private final PrimitiveIntObjectMap<Set<IndexDescriptor>> indexDescriptorsByLabel = Primitive.intObjectMap();
    private final ConstraintSemantics constraintSemantics;
    private final Map<Class<?>, Object> dependantState = new ConcurrentHashMap();
    private final PrimitiveIntObjectMap<List<IndexDescriptor>> indexByProperty = Primitive.intObjectMap();

    public SchemaCache(ConstraintSemantics constraintSemantics, Iterable<SchemaRule> initialRules) {
        this.constraintSemantics = constraintSemantics;
        this.splitUpInitialRules(initialRules);
    }

    private void splitUpInitialRules(Iterable<SchemaRule> initialRules) {
        for (SchemaRule rule : initialRules) {
            this.addSchemaRule(rule);
        }
    }

    public Iterable<IndexRule> indexRules() {
        return this.indexRuleById.values();
    }

    public Iterable<ConstraintRule> constraintRules() {
        return this.constraintRuleById.values();
    }

    public boolean hasConstraintRule(ConstraintDescriptor descriptor) {
        for (ConstraintRule rule : this.constraintRuleById.values()) {
            if (!rule.getConstraintDescriptor().equals(descriptor)) continue;
            return true;
        }
        return false;
    }

    public boolean hasIndexRule(SchemaDescriptor descriptor) {
        for (IndexRule rule : this.indexRuleById.values()) {
            if (!rule.schema().equals(descriptor)) continue;
            return true;
        }
        return false;
    }

    public Iterator<ConstraintDescriptor> constraints() {
        return this.constraints.iterator();
    }

    public Iterator<ConstraintDescriptor> constraintsForLabel(int label) {
        return Iterators.filter(SchemaDescriptorPredicates.hasLabel(label), this.constraints.iterator());
    }

    public Iterator<ConstraintDescriptor> constraintsForRelationshipType(int relTypeId) {
        return Iterators.filter(SchemaDescriptorPredicates.hasRelType(relTypeId), this.constraints.iterator());
    }

    public Iterator<ConstraintDescriptor> constraintsForSchema(SchemaDescriptor descriptor) {
        return Iterators.filter(SchemaDescriptor.equalTo(descriptor), this.constraints.iterator());
    }

    public <P, T> T getOrCreateDependantState(Class<T> type, Function<P, T> factory, P parameter) {
        return type.cast(this.dependantState.computeIfAbsent(type, key -> factory.apply(parameter)));
    }

    public void addSchemaRule(SchemaRule rule) {
        this.dependantState.clear();
        if (rule instanceof ConstraintRule) {
            ConstraintRule constraintRule = (ConstraintRule)rule;
            this.constraintRuleById.put(constraintRule.getId(), constraintRule);
            this.constraints.add(this.constraintSemantics.readConstraint(constraintRule));
        } else if (rule instanceof IndexRule) {
            IndexRule indexRule = (IndexRule)rule;
            this.indexRuleById.put(indexRule.getId(), indexRule);
            LabelSchemaDescriptor schema = indexRule.schema();
            this.indexDescriptors.put(schema, indexRule.getIndexDescriptor());
            HashSet<IndexDescriptor> forLabel = (HashSet<IndexDescriptor>)this.indexDescriptorsByLabel.get(schema.getLabelId());
            if (forLabel == null) {
                forLabel = new HashSet<IndexDescriptor>();
                this.indexDescriptorsByLabel.put(schema.getLabelId(), forLabel);
            }
            forLabel.add(indexRule.getIndexDescriptor());
            for (int propertyId : indexRule.schema().getPropertyIds()) {
                LinkedList<IndexDescriptor> indexesForProperty = (LinkedList<IndexDescriptor>)this.indexByProperty.get(propertyId);
                if (indexesForProperty == null) {
                    indexesForProperty = new LinkedList<IndexDescriptor>();
                    this.indexByProperty.put(propertyId, indexesForProperty);
                }
                indexesForProperty.add(indexRule.getIndexDescriptor());
            }
        }
    }

    public void clear() {
        this.indexRuleById.clear();
        this.constraintRuleById.clear();
        this.constraints.clear();
        this.indexDescriptors.clear();
        this.indexByProperty.clear();
    }

    public void load(List<SchemaRule> schemaRuleIterator) {
        this.clear();
        for (SchemaRule schemaRule : schemaRuleIterator) {
            this.addSchemaRule(schemaRule);
        }
    }

    public void removeSchemaRule(long id) {
        this.dependantState.clear();
        if (this.constraintRuleById.containsKey(id)) {
            ConstraintRule rule = this.constraintRuleById.remove(id);
            this.constraints.remove(this.constraintSemantics.readConstraint(rule));
        } else if (this.indexRuleById.containsKey(id)) {
            IndexRule rule = this.indexRuleById.remove(id);
            LabelSchemaDescriptor schema = rule.schema();
            this.indexDescriptors.remove(schema);
            Set forLabel = (Set)this.indexDescriptorsByLabel.get(schema.getLabelId());
            forLabel.remove(rule.getIndexDescriptor());
            if (forLabel.isEmpty()) {
                this.indexDescriptorsByLabel.remove(schema.getLabelId());
            }
            for (int propertyId : rule.schema().getPropertyIds()) {
                List forProperty = (List)this.indexByProperty.get(propertyId);
                forProperty.remove(rule.getIndexDescriptor());
                if (!forProperty.isEmpty()) continue;
                this.indexByProperty.remove(propertyId);
            }
        }
    }

    public IndexDescriptor indexDescriptor(LabelSchemaDescriptor descriptor) {
        return this.indexDescriptors.get(descriptor);
    }

    public Iterator<IndexDescriptor> indexDescriptorsForLabel(int labelId) {
        Set forLabel = (Set)this.indexDescriptorsByLabel.get(labelId);
        return forLabel == null ? Collections.emptyIterator() : forLabel.iterator();
    }

    public Iterator<IndexDescriptor> indexesByProperty(int propertyId) {
        List indexes = (List)this.indexByProperty.get(propertyId);
        return indexes == null ? Collections.emptyIterator() : indexes.iterator();
    }
}

