/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.function.Consumer;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.index.GBPTreeUtil;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.FailureHeaderWriter;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexHeaderWriter;
import org.neo4j.kernel.impl.index.schema.NativeSchemaNumberIndex;
import org.neo4j.kernel.impl.index.schema.NativeSchemaNumberIndexUpdater;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;

public abstract class NativeSchemaNumberIndexPopulator<KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue>
extends NativeSchemaNumberIndex<KEY, VALUE>
implements IndexPopulator {
    static final byte BYTE_FAILED = 0;
    static final byte BYTE_ONLINE = 1;
    static final byte BYTE_POPULATING = 2;
    private final KEY treeKey;
    private final VALUE treeValue;
    private final ConflictDetectingValueMerger<KEY, VALUE> conflictDetectingValueMerger;
    private final NativeSchemaNumberIndexUpdater<KEY, VALUE> singleUpdater;
    private Writer<KEY, VALUE> singleTreeWriter;
    private byte[] failureBytes;
    private boolean dropped;

    NativeSchemaNumberIndexPopulator(PageCache pageCache, File storeFile, Layout<KEY, VALUE> layout) {
        super(pageCache, storeFile, layout);
        this.treeKey = (SchemaNumberKey)((Object)layout.newKey());
        this.treeValue = (SchemaNumberValue)layout.newValue();
        this.conflictDetectingValueMerger = new ConflictDetectingValueMerger();
        this.singleUpdater = new NativeSchemaNumberIndexUpdater<SchemaNumberKey, SchemaNumberValue>((SchemaNumberKey)((Object)layout.newKey()), (SchemaNumberValue)layout.newValue());
    }

    @Override
    public synchronized void create() throws IOException {
        GBPTreeUtil.deleteIfPresent(this.pageCache, this.storeFile);
        this.instantiateTree(RecoveryCleanupWorkCollector.IMMEDIATE, new NativeSchemaIndexHeaderWriter(2));
        this.instantiateWriter();
    }

    void instantiateWriter() throws IOException {
        assert (this.singleTreeWriter == null);
        this.singleTreeWriter = this.tree.writer();
    }

    @Override
    public synchronized void drop() throws IOException {
        try {
            this.closeWriter();
            this.closeTree();
            GBPTreeUtil.deleteIfPresent(this.pageCache, this.storeFile);
        }
        finally {
            this.dropped = true;
        }
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates) throws IndexEntryConflictException, IOException {
        for (IndexEntryUpdate<?> update : updates) {
            this.add(update);
        }
    }

    @Override
    public void add(IndexEntryUpdate<?> update) throws IndexEntryConflictException, IOException {
        NativeSchemaNumberIndexUpdater.processAdd(this.treeKey, this.treeValue, update, this.singleTreeWriter, this.conflictDetectingValueMerger);
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
    }

    @Override
    public IndexUpdater newPopulatingUpdater(PropertyAccessor accessor) throws IOException {
        return this.singleUpdater.initialize(this.singleTreeWriter, false);
    }

    @Override
    public synchronized void close(boolean populationCompletedSuccessfully) throws IOException {
        this.closeWriter();
        if (populationCompletedSuccessfully && this.failureBytes != null) {
            throw new IllegalStateException("Can't mark index as online after it has been marked as failure");
        }
        try {
            if (populationCompletedSuccessfully) {
                this.assertPopulatorOpen();
                this.markTreeAsOnline();
            } else {
                this.assertNotDropped();
                this.ensureTreeInstantiated();
                this.markTreeAsFailed();
            }
        }
        finally {
            this.closeTree();
        }
    }

    private void assertNotDropped() {
        if (this.dropped) {
            throw new IllegalStateException("Populator has already been dropped.");
        }
    }

    @Override
    public void markAsFailed(String failure) throws IOException {
        this.failureBytes = failure.getBytes(StandardCharsets.UTF_8);
    }

    private void ensureTreeInstantiated() throws IOException {
        if (this.tree == null) {
            this.instantiateTree(RecoveryCleanupWorkCollector.NULL, GBPTree.NO_HEADER_WRITER);
        }
    }

    private void assertPopulatorOpen() {
        if (this.tree == null) {
            throw new IllegalStateException("Populator has already been closed.");
        }
    }

    private void markTreeAsFailed() throws IOException {
        if (this.failureBytes == null) {
            this.failureBytes = new byte[0];
        }
        this.tree.checkpoint(IOLimiter.unlimited(), (Consumer)new FailureHeaderWriter(this.failureBytes));
    }

    private void markTreeAsOnline() throws IOException {
        this.tree.checkpoint(IOLimiter.unlimited(), pc -> pc.putByte((byte)1));
    }

    void closeWriter() throws IOException {
        this.singleTreeWriter = this.closeIfPresent(this.singleTreeWriter);
    }
}

