/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.IndexSampler;

class FusionIndexSampler
implements IndexSampler {
    private final IndexSampler nativeSampler;
    private final IndexSampler luceneSampler;

    FusionIndexSampler(IndexSampler nativeSampler, IndexSampler luceneSampler) {
        this.nativeSampler = nativeSampler;
        this.luceneSampler = luceneSampler;
    }

    @Override
    public IndexSample sampleIndex() throws IndexNotFoundKernelException {
        return FusionIndexSampler.combineSamples(this.nativeSampler.sampleIndex(), this.luceneSampler.sampleIndex());
    }

    static IndexSample combineSamples(IndexSample first, IndexSample other) {
        return new IndexSample(first.indexSize() + other.indexSize(), first.uniqueValues() + other.uniqueValues(), first.sampleSize() + other.sampleSize());
    }
}

