/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.helpers.collection.PrefetchingIterator;

public class ArrayCollection<T>
implements Collection<T> {
    private final int initialCapacity;
    private Object[] array;
    private int size;
    private final int fastClearThreshold;

    public ArrayCollection(int initialCapacity) {
        this(initialCapacity, initialCapacity);
    }

    public ArrayCollection(int initialCapacity, int fastClearThreshold) {
        this.initialCapacity = initialCapacity;
        this.fastClearThreshold = Math.min(fastClearThreshold, initialCapacity);
        this.array = new Object[initialCapacity];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        assert (o != null);
        for (int i = 0; i < this.size; ++i) {
            if (!o.equals(this.array[i])) continue;
            return true;
        }
        return false;
    }

    private T item(int at) {
        return (T)this.array[at];
    }

    @Override
    public Iterator<T> iterator() {
        return new PrefetchingIterator<T>(){
            private int iteratorCursor;

            protected T fetchNextOrNull() {
                return this.iteratorCursor < ArrayCollection.this.size ? ArrayCollection.this.item(this.iteratorCursor++) : null;
            }
        };
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.array, this.size);
    }

    @Override
    public <R> R[] toArray(R[] a) {
        R[] result = a.length >= this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        System.arraycopy(this.array, 0, result, 0, this.size);
        return result;
    }

    @Override
    public boolean add(T e) {
        this.ensureCapacity(this.size + 1);
        this.add0(e);
        return true;
    }

    private void add0(T e) {
        assert (e != null);
        this.array[this.size++] = e;
    }

    private void ensureCapacity(int capacity) {
        if (capacity > this.array.length) {
            int newCapacity;
            for (newCapacity = this.array.length; newCapacity < capacity; newCapacity <<= 1) {
            }
            this.array = Arrays.copyOf(this.array, newCapacity);
        }
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Please implement if needed");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("Please implement if needed");
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (c.isEmpty()) {
            return false;
        }
        this.ensureCapacity(this.size + c.size());
        for (T item : c) {
            this.add0(item);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Please implement if needed");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Please implement if needed");
    }

    @Override
    public void clear() {
        if (this.size > this.fastClearThreshold) {
            this.array = new Object[this.initialCapacity];
        }
        this.size = 0;
    }

    public String toString() {
        return "ArrayCollection{array=" + Arrays.toString(this.array) + '}';
    }
}

