/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.unsafe.impl.batchimport.RecordProcessor;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;

public class NodeCountsProcessor
implements RecordProcessor<NodeRecord> {
    private final NodeStore nodeStore;
    private final long[] labelCounts;
    private MigrationProgressMonitor.Section progressMonitor;
    private final NodeLabelsCache cache;
    private final CountsAccessor.Updater counts;
    private final int anyLabel;

    NodeCountsProcessor(NodeStore nodeStore, NodeLabelsCache cache, int highLabelId, CountsAccessor.Updater counts, MigrationProgressMonitor.Section progressMonitor) {
        this.nodeStore = nodeStore;
        this.cache = cache;
        this.anyLabel = highLabelId;
        this.counts = counts;
        this.labelCounts = new long[highLabelId + 1];
        this.progressMonitor = progressMonitor;
    }

    @Override
    public boolean process(NodeRecord node) {
        long[] labels = NodeLabelsField.get(node, this.nodeStore);
        if (labels.length > 0) {
            for (long labelId : labels) {
                int n = (int)labelId;
                this.labelCounts[n] = this.labelCounts[n] + 1L;
            }
            this.cache.put(node.getId(), labels);
        }
        int n = this.anyLabel;
        this.labelCounts[n] = this.labelCounts[n] + 1L;
        this.progressMonitor.progress(1L);
        return false;
    }

    @Override
    public void done() {
        for (int i = 0; i < this.labelCounts.length; ++i) {
            this.counts.incrementNodeCount(i == this.anyLabel ? -1 : i, this.labelCounts[i]);
        }
    }
}

