/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Arrays;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.LongerShortString;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public enum PropertyType {
    BOOL(1){

        @Override
        public Value value(PropertyBlock block, PropertyStore store) {
            return Values.booleanValue((boolean)this.getValue(block.getSingleValueLong()));
        }

        private boolean getValue(long propBlock) {
            return (propBlock & 1L) == 1L;
        }
    }
    ,
    BYTE(2){

        @Override
        public Value value(PropertyBlock block, PropertyStore store) {
            return Values.byteValue((byte)block.getSingleValueByte());
        }
    }
    ,
    SHORT(3){

        @Override
        public Value value(PropertyBlock block, PropertyStore store) {
            return Values.shortValue((short)block.getSingleValueShort());
        }
    }
    ,
    CHAR(4){

        @Override
        public Value value(PropertyBlock block, PropertyStore store) {
            return Values.charValue((char)((char)block.getSingleValueShort()));
        }
    }
    ,
    INT(5){

        @Override
        public Value value(PropertyBlock block, PropertyStore store) {
            return Values.intValue((int)block.getSingleValueInt());
        }
    }
    ,
    LONG(6){

        @Override
        public Value value(PropertyBlock block, PropertyStore store) {
            long firstBlock = block.getSingleValueBlock();
            long value = this.valueIsInlined(firstBlock) ? block.getSingleValueLong() >>> 1 : block.getValueBlocks()[1];
            return Values.longValue((long)value);
        }

        private boolean valueIsInlined(long firstBlock) {
            return (firstBlock & 0x10000000L) > 0L;
        }

        @Override
        public int calculateNumberOfBlocksUsed(long firstBlock) {
            return this.valueIsInlined(firstBlock) ? 1 : 2;
        }
    }
    ,
    FLOAT(7){

        @Override
        public Value value(PropertyBlock block, PropertyStore store) {
            return Values.floatValue((float)Float.intBitsToFloat(block.getSingleValueInt()));
        }
    }
    ,
    DOUBLE(8){

        @Override
        public Value value(PropertyBlock block, PropertyStore store) {
            return Values.doubleValue((double)Double.longBitsToDouble(block.getValueBlocks()[1]));
        }

        @Override
        public int calculateNumberOfBlocksUsed(long firstBlock) {
            return 2;
        }
    }
    ,
    STRING(9){

        @Override
        public Value value(PropertyBlock block, PropertyStore store) {
            return Values.stringValue((String)store.getStringFor(block));
        }

        @Override
        public byte[] readDynamicRecordHeader(byte[] recordBytes) {
            return EMPTY_BYTE_ARRAY;
        }
    }
    ,
    ARRAY(10){

        @Override
        public Value value(PropertyBlock block, PropertyStore store) {
            return store.getArrayFor(block);
        }

        @Override
        public byte[] readDynamicRecordHeader(byte[] recordBytes) {
            byte itemType = recordBytes[0];
            if (itemType == STRING.byteValue()) {
                return this.headOf(recordBytes, 5);
            }
            if (itemType <= DOUBLE.byteValue()) {
                return this.headOf(recordBytes, 3);
            }
            throw new IllegalArgumentException("Unknown array type " + itemType);
        }

        private byte[] headOf(byte[] bytes, int length) {
            return Arrays.copyOf(bytes, length);
        }
    }
    ,
    SHORT_STRING(11){

        @Override
        public Value value(PropertyBlock block, PropertyStore store) {
            return LongerShortString.decode(block);
        }

        @Override
        public int calculateNumberOfBlocksUsed(long firstBlock) {
            return LongerShortString.calculateNumberOfBlocksUsed(firstBlock);
        }
    }
    ,
    SHORT_ARRAY(12){

        @Override
        public Value value(PropertyBlock block, PropertyStore store) {
            return ShortArray.decode(block);
        }

        @Override
        public int calculateNumberOfBlocksUsed(long firstBlock) {
            return ShortArray.calculateNumberOfBlocksUsed(firstBlock);
        }
    };

    public static final byte[] EMPTY_BYTE_ARRAY;
    public static final int BLOCKS_USED_FOR_BAD_TYPE_OR_ENCODING = -1;
    private static int payloadSize;
    private final int type;

    private PropertyType(int type) {
        this.type = type;
    }

    public int intValue() {
        return this.type;
    }

    public byte byteValue() {
        return (byte)this.type;
    }

    public abstract Value value(PropertyBlock var1, PropertyStore var2);

    public static PropertyType getPropertyTypeOrNull(long propBlock) {
        int type = PropertyType.typeIdentifier(propBlock);
        switch (type) {
            case 1: {
                return BOOL;
            }
            case 2: {
                return BYTE;
            }
            case 3: {
                return SHORT;
            }
            case 4: {
                return CHAR;
            }
            case 5: {
                return INT;
            }
            case 6: {
                return LONG;
            }
            case 7: {
                return FLOAT;
            }
            case 8: {
                return DOUBLE;
            }
            case 9: {
                return STRING;
            }
            case 10: {
                return ARRAY;
            }
            case 11: {
                return SHORT_STRING;
            }
            case 12: {
                return SHORT_ARRAY;
            }
        }
        return null;
    }

    private static int typeIdentifier(long propBlock) {
        return (int)((propBlock & 0xF000000L) >> 24);
    }

    public static PropertyType getPropertyTypeOrThrow(long propBlock) {
        PropertyType type = PropertyType.getPropertyTypeOrNull(propBlock);
        if (type == null) {
            throw new InvalidRecordException("Unknown property type for type " + PropertyType.typeIdentifier(propBlock));
        }
        return type;
    }

    public static int getPayloadSize() {
        return payloadSize;
    }

    public static int getPayloadSizeLongs() {
        return payloadSize >>> 3;
    }

    public int calculateNumberOfBlocksUsed(long firstBlock) {
        return 1;
    }

    public byte[] readDynamicRecordHeader(byte[] recordBytes) {
        throw new UnsupportedOperationException();
    }

    static {
        EMPTY_BYTE_ARRAY = new byte[0];
        payloadSize = 32;
    }
}

