/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;

public class PhysicalFlushableChannel
implements FlushableChannel {
    private volatile boolean closed;
    protected final ByteBuffer buffer;
    protected StoreChannel channel;

    public PhysicalFlushableChannel(StoreChannel channel) {
        this(channel, (int)ByteUnit.kibiBytes((long)512L));
    }

    public PhysicalFlushableChannel(StoreChannel channel, int bufferSize) {
        this.channel = channel;
        this.buffer = ByteBuffer.allocate(bufferSize);
    }

    void setChannel(LogVersionedStoreChannel channel) {
        this.channel = channel;
    }

    @Override
    public Flushable prepareForFlush() throws IOException {
        this.buffer.flip();
        StoreChannel channel = this.channel;
        try {
            channel.writeAll(this.buffer);
        }
        catch (ClosedChannelException e) {
            this.handleClosedChannelException(e);
        }
        this.buffer.clear();
        return channel;
    }

    private void handleClosedChannelException(ClosedChannelException e) throws ClosedChannelException {
        if (this.closed) {
            throw new IllegalStateException("This log channel has been closed", e);
        }
        throw e;
    }

    @Override
    public FlushableChannel put(byte value) throws IOException {
        this.bufferWithGuaranteedSpace(1).put(value);
        return this;
    }

    @Override
    public FlushableChannel putShort(short value) throws IOException {
        this.bufferWithGuaranteedSpace(2).putShort(value);
        return this;
    }

    @Override
    public FlushableChannel putInt(int value) throws IOException {
        this.bufferWithGuaranteedSpace(4).putInt(value);
        return this;
    }

    @Override
    public FlushableChannel putLong(long value) throws IOException {
        this.bufferWithGuaranteedSpace(8).putLong(value);
        return this;
    }

    @Override
    public FlushableChannel putFloat(float value) throws IOException {
        this.bufferWithGuaranteedSpace(4).putFloat(value);
        return this;
    }

    @Override
    public FlushableChannel putDouble(double value) throws IOException {
        this.bufferWithGuaranteedSpace(8).putDouble(value);
        return this;
    }

    @Override
    public FlushableChannel put(byte[] value, int length) throws IOException {
        int chunkSize;
        for (int offset = 0; offset < length; offset += chunkSize) {
            chunkSize = Math.min(length - offset, this.buffer.capacity() >> 1);
            this.bufferWithGuaranteedSpace(chunkSize).put(value, offset, chunkSize);
        }
        return this;
    }

    private ByteBuffer bufferWithGuaranteedSpace(int spaceInBytes) throws IOException {
        assert (spaceInBytes < this.buffer.capacity());
        if (this.buffer.remaining() < spaceInBytes) {
            this.prepareForFlush();
        }
        return this.buffer;
    }

    @Override
    public void close() throws IOException {
        this.prepareForFlush().flush();
        this.closed = true;
        this.channel.close();
    }

    public long position() throws IOException {
        return this.channel.position() + (long)this.buffer.position();
    }

    public void position(long position) throws IOException {
        this.prepareForFlush().flush();
        this.channel.position(position);
    }
}

