/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public class RelationshipRecordPreparationStep
extends ProcessorStep<Batch<InputRelationship, RelationshipRecord>> {
    private final BatchingTokenRepository.BatchingRelationshipTypeTokenRepository relationshipTypeRepository;
    private final Collector badCollector;

    public RelationshipRecordPreparationStep(StageControl control, Configuration config, BatchingTokenRepository.BatchingRelationshipTypeTokenRepository relationshipTypeRepository, Collector badCollector) {
        super(control, "RECORDS", config, 0, new StatsProvider[0]);
        this.relationshipTypeRepository = relationshipTypeRepository;
        this.badCollector = badCollector;
    }

    @Override
    protected void process(Batch<InputRelationship, RelationshipRecord> batch, BatchSender sender) throws Throwable {
        batch.records = new RelationshipRecord[((InputRelationship[])batch.input).length];
        long id = batch.firstRecordId;
        int i = 0;
        int idIndex = 0;
        while (i < ((RelationshipRecord[])batch.records).length) {
            RelationshipRecord relationshipRecord = new RelationshipRecord(id);
            ((RelationshipRecord[])batch.records)[i] = relationshipRecord;
            RelationshipRecord relationship = relationshipRecord;
            InputRelationship batchRelationship = ((InputRelationship[])batch.input)[i];
            long startNodeId = batch.ids[idIndex++];
            long endNodeId = batch.ids[idIndex++];
            boolean hasType = batchRelationship.hasType();
            if (startNodeId == -1L || endNodeId == -1L || !hasType) {
                this.collectBadRelationship(batchRelationship, startNodeId, endNodeId, hasType);
            } else {
                relationship.setInUse(true);
                relationship.setFirstInFirstChain(false);
                relationship.setFirstInSecondChain(false);
                relationship.setFirstPrevRel(Record.NO_NEXT_RELATIONSHIP.intValue());
                relationship.setSecondPrevRel(Record.NO_NEXT_RELATIONSHIP.intValue());
                relationship.setFirstNode(startNodeId);
                relationship.setSecondNode(endNodeId);
                int typeId = batchRelationship.hasTypeId() ? batchRelationship.typeId() : this.relationshipTypeRepository.getOrCreateId(batchRelationship.type());
                relationship.setType(typeId);
            }
            ++i;
            ++id;
        }
        sender.send(batch);
    }

    private void collectBadRelationship(InputRelationship batchRelationship, long startNodeId, long endNodeId, boolean hasType) {
        if (!hasType) {
            this.badCollector.collectBadRelationship(batchRelationship, null);
        } else {
            if (startNodeId == -1L) {
                this.badCollector.collectBadRelationship(batchRelationship, batchRelationship.startNode());
            }
            if (endNodeId == -1L) {
                this.badCollector.collectBadRelationship(batchRelationship, batchRelationship.endNode());
            }
        }
    }
}

