/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.util.Collection;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.util.collection.ArrayCollection;

public abstract class BatchingRecordAccess<RECORD, ADDITIONAL>
implements RecordAccess<RECORD, ADDITIONAL> {
    private final Collection<RecordAccess.RecordProxy<RECORD, ADDITIONAL>> proxies = new ArrayCollection<RecordAccess.RecordProxy<RECORD, ADDITIONAL>>(1000);

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> getOrLoad(long key, ADDITIONAL additionalData) {
        throw new UnsupportedOperationException("We only support creations here");
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> create(long key, ADDITIONAL additionalData) {
        RECORD record = this.createRecord(key, additionalData);
        BatchingRecordProxy proxy = new BatchingRecordProxy(key, record, additionalData);
        this.proxies.add(proxy);
        return proxy;
    }

    protected abstract RECORD createRecord(long var1, ADDITIONAL var3);

    public Iterable<RECORD> records() {
        return new IterableWrapper<RECORD, RecordAccess.RecordProxy<RECORD, ADDITIONAL>>(this.proxies){

            protected RECORD underlyingObjectToObject(RecordAccess.RecordProxy<RECORD, ADDITIONAL> object) {
                return object.forReadingLinkage();
            }
        };
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> getIfLoaded(long key) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void setTo(long key, RECORD newRecord, ADDITIONAL additionalData) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> setRecord(long key, RECORD record, ADDITIONAL additionalData) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int changeSize() {
        return this.proxies.size();
    }

    @Override
    public Iterable<RecordAccess.RecordProxy<RECORD, ADDITIONAL>> changes() {
        return this.proxies;
    }

    @Override
    public void close() {
        this.proxies.clear();
    }

    public static class BatchingRecordProxy<RECORD, ADDITIONAL>
    implements RecordAccess.RecordProxy<RECORD, ADDITIONAL> {
        private final long key;
        private final RECORD record;
        private final ADDITIONAL additional;

        private BatchingRecordProxy(long key, RECORD record, ADDITIONAL additional) {
            this.key = key;
            this.record = record;
            this.additional = additional;
        }

        @Override
        public long getKey() {
            return this.key;
        }

        @Override
        public RECORD forChangingLinkage() {
            return this.record;
        }

        @Override
        public RECORD forChangingData() {
            return this.record;
        }

        @Override
        public RECORD forReadingLinkage() {
            return this.record;
        }

        @Override
        public RECORD forReadingData() {
            return this.record;
        }

        @Override
        public ADDITIONAL getAdditionalData() {
            return this.additional;
        }

        @Override
        public RECORD getBefore() {
            return null;
        }

        @Override
        public boolean isChanged() {
            return true;
        }

        @Override
        public boolean isCreated() {
            return true;
        }
    }
}

