/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import org.neo4j.kernel.impl.api.state.StateDefaults;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.util.diffsets.DiffSets;
import org.neo4j.storageengine.api.txstate.ReadableDiffSets;

public abstract class LabelState {
    private static final LabelState DEFAULT = new LabelState(){

        @Override
        public ReadableDiffSets<Long> nodeDiffSets() {
            return ReadableDiffSets.Empty.instance();
        }
    };

    public abstract ReadableDiffSets<Long> nodeDiffSets();

    private LabelState() {
    }

    static abstract class Defaults
    extends StateDefaults<Integer, LabelState, Mutable> {
        Defaults() {
        }

        @Override
        Mutable createValue(Integer key, TxState state) {
            return new Mutable(key);
        }

        @Override
        LabelState defaultValue() {
            return DEFAULT;
        }
    }

    public static class Mutable
    extends LabelState {
        private DiffSets<Long> nodeDiffSets;
        private final int labelId;

        private Mutable(int labelId) {
            this.labelId = labelId;
        }

        public int getLabelId() {
            return this.labelId;
        }

        @Override
        public ReadableDiffSets<Long> nodeDiffSets() {
            return ReadableDiffSets.Empty.ifNull(this.nodeDiffSets);
        }

        public DiffSets<Long> getOrCreateNodeDiffSets() {
            if (this.nodeDiffSets == null) {
                this.nodeDiffSets = new DiffSets();
            }
            return this.nodeDiffSets;
        }
    }
}

