/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.ReverseArrayIterator;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.virtual.CoordinateReferenceSystem;
import org.neo4j.values.virtual.EdgeValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;

public abstract class BaseToObjectValueWriter<E extends Exception>
implements AnyValueWriter<E> {
    private final Deque<Writer> stack = new ArrayDeque<Writer>();

    public BaseToObjectValueWriter() {
        this.stack.push(new ObjectWriter());
    }

    protected abstract Node newNodeProxyById(long var1);

    protected abstract Relationship newRelationshipProxyById(long var1);

    protected abstract Point newGeographicPoint(double var1, double var3, String var5, int var6, String var7);

    protected abstract Point newCartesianPoint(double var1, double var3, String var5, int var6, String var7);

    public Object value() {
        assert (this.stack.size() == 1);
        return this.stack.getLast().value();
    }

    private void writeValue(Object value) {
        assert (!this.stack.isEmpty());
        Writer head = this.stack.peek();
        head.write(value);
    }

    public void writeNodeReference(long nodeId) throws RuntimeException {
        this.writeValue(this.newNodeProxyById(nodeId));
    }

    public void writeNode(long nodeId, TextArray ignore, MapValue properties) throws RuntimeException {
        if (nodeId >= 0L) {
            this.writeValue(this.newNodeProxyById(nodeId));
        }
    }

    public void writeEdgeReference(long edgeId) throws RuntimeException {
        this.writeValue(this.newRelationshipProxyById(edgeId));
    }

    public void writeEdge(long edgeId, long startNodeId, long endNodeId, TextValue type, MapValue properties) throws RuntimeException {
        if (edgeId >= 0L) {
            this.writeValue(this.newRelationshipProxyById(edgeId));
        }
    }

    public void beginMap(int size) throws RuntimeException {
        this.stack.push(new MapWriter(size));
    }

    public void endMap() throws RuntimeException {
        assert (!this.stack.isEmpty());
        this.writeValue(this.stack.pop().value());
    }

    public void beginList(int size) throws RuntimeException {
        this.stack.push(new ListWriter(size));
    }

    public void endList() throws RuntimeException {
        assert (!this.stack.isEmpty());
        this.writeValue(this.stack.pop().value());
    }

    public void writePath(NodeValue[] nodes, EdgeValue[] edges) throws RuntimeException {
        assert (nodes != null);
        assert (nodes.length > 0);
        assert (edges != null);
        assert (nodes.length == edges.length + 1);
        final Node[] nodeProxies = new Node[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            nodeProxies[i] = this.newNodeProxyById(nodes[i].id());
        }
        final Relationship[] relationship = new Relationship[edges.length];
        for (int i = 0; i < edges.length; ++i) {
            relationship[i] = this.newRelationshipProxyById(edges[i].id());
        }
        this.writeValue(new Path(){

            public Node startNode() {
                return nodeProxies[0];
            }

            public Node endNode() {
                return nodeProxies[nodeProxies.length - 1];
            }

            public Relationship lastRelationship() {
                return relationship[relationship.length - 1];
            }

            public Iterable<Relationship> relationships() {
                return Arrays.asList(relationship);
            }

            public Iterable<Relationship> reverseRelationships() {
                return () -> new ReverseArrayIterator((Object[])relationship);
            }

            public Iterable<Node> nodes() {
                return Arrays.asList(nodeProxies);
            }

            public Iterable<Node> reverseNodes() {
                return () -> new ReverseArrayIterator((Object[])nodeProxies);
            }

            public int length() {
                return relationship.length;
            }

            public int hashCode() {
                if (relationship.length == 0) {
                    return this.startNode().hashCode();
                }
                return Arrays.hashCode(relationship);
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj instanceof Path) {
                    Path other = (Path)obj;
                    return this.startNode().equals(other.startNode()) && Iterators.iteratorsEqual(this.relationships().iterator(), other.relationships().iterator());
                }
                return false;
            }

            public Iterator<PropertyContainer> iterator() {
                return new Iterator<PropertyContainer>(){
                    Iterator<? extends PropertyContainer> current;
                    Iterator<? extends PropertyContainer> next;
                    {
                        this.current = this.nodes().iterator();
                        this.next = this.relationships().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.current.hasNext();
                    }

                    @Override
                    public PropertyContainer next() {
                        try {
                            PropertyContainer propertyContainer = this.current.next();
                            return propertyContainer;
                        }
                        finally {
                            Iterator<? extends PropertyContainer> temp = this.current;
                            this.current = this.next;
                            this.next = temp;
                        }
                    }

                    @Override
                    public void remove() {
                        this.next.remove();
                    }
                };
            }
        });
    }

    public void beginPoint(CoordinateReferenceSystem coordinateReferenceSystem) throws RuntimeException {
        this.stack.push(new PointWriter(coordinateReferenceSystem));
    }

    public void endPoint() throws RuntimeException {
        assert (!this.stack.isEmpty());
        this.writeValue(this.stack.pop().value());
    }

    public void writeNull() throws RuntimeException {
        this.writeValue(null);
    }

    public void writeBoolean(boolean value) throws RuntimeException {
        this.writeValue(value);
    }

    public void writeInteger(byte value) throws RuntimeException {
        this.writeValue(value);
    }

    public void writeInteger(short value) throws RuntimeException {
        this.writeValue(value);
    }

    public void writeInteger(int value) throws RuntimeException {
        this.writeValue(value);
    }

    public void writeInteger(long value) throws RuntimeException {
        this.writeValue(value);
    }

    public void writeFloatingPoint(float value) throws RuntimeException {
        this.writeValue(Float.valueOf(value));
    }

    public void writeFloatingPoint(double value) throws RuntimeException {
        this.writeValue(value);
    }

    public void writeString(String value) throws RuntimeException {
        this.writeValue(value);
    }

    public void writeString(char value) throws RuntimeException {
        this.writeValue(Character.valueOf(value));
    }

    public void writeString(char[] value, int offset, int length) throws RuntimeException {
        this.writeValue(new String(value, offset, length));
    }

    public void beginArray(int size, ValueWriter.ArrayType arrayType) throws RuntimeException {
        this.stack.push(new ArrayWriter(size, arrayType));
    }

    public void endArray() throws RuntimeException {
        assert (!this.stack.isEmpty());
        this.writeValue(this.stack.pop().value());
    }

    public void writeByteArray(byte[] value) throws RuntimeException {
        this.writeValue(value);
    }

    public void writeArbitraryJavaObject(Object object) {
        this.writeValue(object);
    }

    private class PointWriter
    implements Writer {
        private final double[] coordinates = new double[2];
        private int index;
        private final CoordinateReferenceSystem crs;

        PointWriter(CoordinateReferenceSystem crs) {
            this.crs = crs;
        }

        @Override
        public void write(Object value) {
            this.coordinates[this.index++] = (Double)value;
        }

        @Override
        public Object value() {
            if (this.crs.code() == CoordinateReferenceSystem.WGS84.code()) {
                return BaseToObjectValueWriter.this.newGeographicPoint(this.coordinates[0], this.coordinates[1], this.crs.name, this.crs.code, this.crs.href);
            }
            if (this.crs.code() == CoordinateReferenceSystem.Cartesian.code()) {
                return BaseToObjectValueWriter.this.newCartesianPoint(this.coordinates[0], this.coordinates[1], this.crs.name, this.crs.code, this.crs.href);
            }
            throw new IllegalArgumentException(this.crs + " is not a supported coordinate reference system");
        }
    }

    private static class ListWriter
    implements Writer {
        private final List<Object> list;

        ListWriter(int size) {
            this.list = new ArrayList<Object>(size);
        }

        @Override
        public void write(Object value) {
            this.list.add(value);
        }

        @Override
        public Object value() {
            return this.list;
        }
    }

    private static class ArrayWriter
    implements Writer {
        protected final Object array;
        private int index;

        ArrayWriter(int size, ValueWriter.ArrayType arrayType) {
            switch (arrayType) {
                case SHORT: {
                    this.array = Array.newInstance(Short.TYPE, size);
                    break;
                }
                case INT: {
                    this.array = Array.newInstance(Integer.TYPE, size);
                    break;
                }
                case BYTE: {
                    this.array = Array.newInstance(Byte.TYPE, size);
                    break;
                }
                case LONG: {
                    this.array = Array.newInstance(Long.TYPE, size);
                    break;
                }
                case FLOAT: {
                    this.array = Array.newInstance(Float.TYPE, size);
                    break;
                }
                case DOUBLE: {
                    this.array = Array.newInstance(Double.TYPE, size);
                    break;
                }
                case BOOLEAN: {
                    this.array = Array.newInstance(Boolean.TYPE, size);
                    break;
                }
                case STRING: {
                    this.array = Array.newInstance(String.class, size);
                    break;
                }
                case CHAR: {
                    this.array = Array.newInstance(Character.TYPE, size);
                    break;
                }
                default: {
                    this.array = new Object[size];
                }
            }
        }

        @Override
        public void write(Object value) {
            Array.set(this.array, this.index++, value);
        }

        @Override
        public Object value() {
            return this.array;
        }
    }

    private static class MapWriter
    implements Writer {
        private String key;
        private boolean isKey = true;
        private final HashMap<String, Object> map;

        MapWriter(int size) {
            this.map = new HashMap(size);
        }

        @Override
        public void write(Object value) {
            if (this.isKey) {
                this.key = (String)value;
                this.isKey = false;
            } else {
                this.map.put(this.key, value);
                this.isKey = true;
            }
        }

        @Override
        public Object value() {
            return this.map;
        }
    }

    private static class ObjectWriter
    implements Writer {
        private Object value;

        private ObjectWriter() {
        }

        @Override
        public void write(Object value) {
            this.value = value;
        }

        @Override
        public Object value() {
            return this.value;
        }
    }

    private static interface Writer {
        public void write(Object var1);

        public Object value();
    }
}

