/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContext;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.impl.store.kvstore.ActiveState;
import org.neo4j.kernel.impl.store.kvstore.BigEndianByteArrayBuffer;
import org.neo4j.kernel.impl.store.kvstore.DataProvider;
import org.neo4j.kernel.impl.store.kvstore.EntryUpdater;
import org.neo4j.kernel.impl.store.kvstore.KeyFormat;
import org.neo4j.kernel.impl.store.kvstore.KeyValueMerger;
import org.neo4j.kernel.impl.store.kvstore.PrototypeState;
import org.neo4j.kernel.impl.store.kvstore.ReadableBuffer;
import org.neo4j.kernel.impl.store.kvstore.ReadableState;
import org.neo4j.kernel.impl.store.kvstore.State;
import org.neo4j.kernel.impl.store.kvstore.ValueSink;
import org.neo4j.kernel.impl.store.kvstore.ValueUpdate;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;

class ConcurrentMapState<Key>
extends ActiveState<Key> {
    private final ConcurrentMap<Key, ChangeEntry> changes;
    private final VersionContextSupplier versionContextSupplier;
    private final File file;
    private final AtomicLong highestAppliedVersion;
    private final AtomicLong appliedChanges;
    private final AtomicBoolean hasTrackedChanges;
    private final long previousVersion;

    ConcurrentMapState(ReadableState<Key> store, File file, VersionContextSupplier versionContextSupplier) {
        super(store, versionContextSupplier);
        this.previousVersion = store.version();
        this.file = file;
        this.versionContextSupplier = versionContextSupplier;
        this.highestAppliedVersion = new AtomicLong(this.previousVersion);
        this.changes = new ConcurrentHashMap<Key, ChangeEntry>();
        this.appliedChanges = new AtomicLong();
        this.hasTrackedChanges = new AtomicBoolean();
    }

    private ConcurrentMapState(Prototype<Key> prototype, ReadableState<Key> store, File file, VersionContextSupplier versionContextSupplier) {
        super(store, versionContextSupplier);
        this.previousVersion = store.version();
        this.versionContextSupplier = versionContextSupplier;
        this.file = file;
        this.hasTrackedChanges = prototype.hasTrackedChanges;
        this.changes = prototype.changes;
        this.highestAppliedVersion = prototype.highestAppliedVersion;
        this.appliedChanges = prototype.appliedChanges;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.file + "]";
    }

    @Override
    public EntryUpdater<Key> updater(long version, Lock lock) {
        if (version <= this.previousVersion) {
            return EntryUpdater.noUpdates();
        }
        ConcurrentMapState.update(this.highestAppliedVersion, version);
        this.hasTrackedChanges.set(true);
        return new Updater<Key>(lock, this.store, this.changes, this.appliedChanges, version);
    }

    @Override
    public EntryUpdater<Key> unsafeUpdater(Lock lock) {
        this.hasTrackedChanges.set(true);
        return new Updater<Key>(lock, this.store, this.changes, null, 1L);
    }

    @Override
    protected long storedVersion() {
        return this.previousVersion;
    }

    @Override
    protected EntryUpdater<Key> resettingUpdater(Lock lock, final Runnable closeAction) {
        if (this.hasChanges()) {
            throw new IllegalStateException("Cannot reset when there are changes!");
        }
        return new EntryUpdater<Key>(lock){

            @Override
            public void apply(Key key, ValueUpdate update) throws IOException {
                this.ensureOpen();
                ConcurrentMapState.applyUpdate(ConcurrentMapState.this.store, ConcurrentMapState.this.changes, key, update, true, ConcurrentMapState.this.highestAppliedVersion.get());
            }

            @Override
            public void close() {
                try {
                    closeAction.run();
                }
                finally {
                    super.close();
                }
            }
        };
    }

    @Override
    protected PrototypeState<Key> prototype(long version) {
        return new Prototype(this, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <Key> void applyUpdate(ReadableState<Key> store, ConcurrentMap<Key, ChangeEntry> changes, Key key, ValueUpdate update, boolean reset, long version) throws IOException {
        ChangeEntry value = (ChangeEntry)changes.get(key);
        if (value == null) {
            ChangeEntry newEntry;
            ChangeEntry changeEntry = newEntry = ChangeEntry.of(new byte[store.keyFormat().valueSize()], version);
            synchronized (changeEntry) {
                value = changes.putIfAbsent(key, newEntry);
                if (value == null) {
                    PreviousValue lookup;
                    BigEndianByteArrayBuffer buffer = new BigEndianByteArrayBuffer(newEntry.data);
                    if (!reset && !store.lookup(key, lookup = new PreviousValue(newEntry.data))) {
                        buffer.clear();
                    }
                    update.update(buffer);
                    return;
                }
            }
        }
        ChangeEntry changeEntry = value;
        synchronized (changeEntry) {
            BigEndianByteArrayBuffer target = new BigEndianByteArrayBuffer(value.data);
            value.version = version;
            if (reset) {
                target.clear();
            }
            update.update(target);
        }
    }

    private static void update(AtomicLong highestAppliedVersion, long version) {
        long high;
        do {
            if (version > (high = highestAppliedVersion.get())) continue;
            return;
        } while (!highestAppliedVersion.compareAndSet(high, version));
    }

    @Override
    protected long version() {
        return this.highestAppliedVersion.get();
    }

    @Override
    protected long applied() {
        return this.appliedChanges.get();
    }

    @Override
    protected boolean hasChanges() {
        return this.hasTrackedChanges.get() && !this.changes.isEmpty();
    }

    @Override
    public void close() throws IOException {
        this.store.close();
    }

    @Override
    protected File file() {
        return this.file;
    }

    @Override
    protected ActiveState.Factory factory() {
        return State.Strategy.CONCURRENT_HASH_MAP;
    }

    @Override
    protected boolean lookup(Key key, ValueSink sink) throws IOException {
        return ConcurrentMapState.performLookup(this.store, this.versionContextSupplier.getVersionContext(), this.changes, key, sink);
    }

    private static <Key> boolean performLookup(ReadableState<Key> store, VersionContext versionContext, ConcurrentMap<Key, ChangeEntry> changes, Key key, ValueSink sink) throws IOException {
        ChangeEntry change = (ChangeEntry)changes.get(key);
        if (change != null) {
            if (change.version > versionContext.lastClosedTransactionId()) {
                versionContext.markAsDirty();
            }
            sink.value(new BigEndianByteArrayBuffer(change.data));
            return true;
        }
        return store.lookup(key, sink);
    }

    @Override
    public DataProvider dataProvider() throws IOException {
        return ConcurrentMapState.dataProvider(this.store, this.changes);
    }

    private static <Key> DataProvider dataProvider(ReadableState<Key> store, ConcurrentMap<Key, ChangeEntry> changes) throws IOException {
        if (changes.isEmpty()) {
            return store.dataProvider();
        }
        KeyFormat<Key> keys = store.keyFormat();
        return new KeyValueMerger(store.dataProvider(), new UpdateProvider(ConcurrentMapState.sortedUpdates(keys, changes)), keys.keySize(), keys.valueSize());
    }

    private static <Key> byte[][] sortedUpdates(KeyFormat<Key> keys, ConcurrentMap<Key, ChangeEntry> changes) {
        Object[] buffer = new Entry[changes.size()];
        Iterator entries = changes.entrySet().iterator();
        for (int i = 0; i < buffer.length; ++i) {
            Map.Entry next = entries.next();
            byte[] key = new byte[keys.keySize()];
            keys.writeKey(next.getKey(), new BigEndianByteArrayBuffer(key));
            buffer[i] = new Entry(key, ((ChangeEntry)next.getValue()).data);
        }
        Arrays.sort(buffer);
        assert (!entries.hasNext()) : "We hold the lock, so we should see 'size' entries.";
        byte[][] result = new byte[buffer.length * 2][];
        for (int i = 0; i < buffer.length; ++i) {
            result[i * 2] = ((Entry)buffer[i]).key;
            result[i * 2 + 1] = ((Entry)buffer[i]).value;
        }
        return result;
    }

    private static class ChangeEntry {
        private byte[] data;
        private long version;

        static ChangeEntry of(byte[] data, long version) {
            return new ChangeEntry(data, version);
        }

        ChangeEntry(byte[] data, long version) {
            this.data = data;
            this.version = version;
        }
    }

    private static class UpdateProvider
    implements DataProvider {
        private final byte[][] data;
        private int i;

        UpdateProvider(byte[][] data) {
            this.data = data;
        }

        @Override
        public boolean visit(WritableBuffer key, WritableBuffer value) throws IOException {
            if (this.i < this.data.length) {
                key.put(0, this.data[this.i]);
                value.put(0, this.data[this.i + 1]);
                this.i += 2;
                return true;
            }
            return false;
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class Entry
    implements Comparable<Entry> {
        final byte[] key;
        final byte[] value;

        private Entry(byte[] key, byte[] value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int compareTo(Entry that) {
            return BigEndianByteArrayBuffer.compare(this.key, that.key, 0);
        }
    }

    private static class PreviousValue
    extends ValueSink {
        private final byte[] proposal;

        PreviousValue(byte[] proposal) {
            this.proposal = proposal;
        }

        @Override
        protected void value(ReadableBuffer value) {
            value.get(0, this.proposal);
        }
    }

    private static class Prototype<Key>
    extends PrototypeState<Key> {
        final ConcurrentMap<Key, ChangeEntry> changes = new ConcurrentHashMap<Key, ChangeEntry>();
        final AtomicLong highestAppliedVersion;
        final AtomicLong appliedChanges = new AtomicLong();
        final VersionContextSupplier versionContextSupplier;
        final AtomicBoolean hasTrackedChanges;
        private final long threshold;

        Prototype(ConcurrentMapState<Key> state, long version) {
            super(state);
            this.versionContextSupplier = ((ConcurrentMapState)state).versionContextSupplier;
            this.threshold = version;
            this.hasTrackedChanges = new AtomicBoolean();
            this.highestAppliedVersion = new AtomicLong(version);
        }

        @Override
        protected ActiveState<Key> create(ReadableState<Key> sub, File file, VersionContextSupplier versionContextSupplier) {
            return new ConcurrentMapState(this, sub, file, versionContextSupplier);
        }

        @Override
        protected EntryUpdater<Key> updater(long version, Lock lock) {
            ConcurrentMapState.update(this.highestAppliedVersion, version);
            if (version > this.threshold) {
                this.hasTrackedChanges.set(true);
                return new Updater<Key>(lock, this.store, this.changes, this.appliedChanges, version);
            }
            return new Updater<Key>(lock, this.store, this.changes, null, version);
        }

        @Override
        protected EntryUpdater<Key> unsafeUpdater(Lock lock) {
            this.hasTrackedChanges.set(true);
            return new Updater<Key>(lock, this.store, this.changes, null, this.highestAppliedVersion.get());
        }

        @Override
        protected boolean hasChanges() {
            return this.hasTrackedChanges.get() && !this.changes.isEmpty();
        }

        @Override
        protected long version() {
            return this.highestAppliedVersion.get();
        }

        @Override
        protected boolean lookup(Key key, ValueSink sink) throws IOException {
            return ConcurrentMapState.performLookup(this.store, this.versionContextSupplier.getVersionContext(), this.changes, key, sink);
        }

        @Override
        protected DataProvider dataProvider() throws IOException {
            return ConcurrentMapState.dataProvider(this.store, this.changes);
        }
    }

    private static class Updater<Key>
    extends EntryUpdater<Key> {
        private AtomicLong changeCounter;
        private final ReadableState<Key> store;
        private final ConcurrentMap<Key, ChangeEntry> changes;
        private final long version;

        Updater(Lock lock, ReadableState<Key> store, ConcurrentMap<Key, ChangeEntry> changes, AtomicLong changeCounter, long version) {
            super(lock);
            this.changeCounter = changeCounter;
            this.store = store;
            this.changes = changes;
            this.version = version;
        }

        @Override
        public void apply(Key key, ValueUpdate update) throws IOException {
            this.ensureOpenOnSameThread();
            ConcurrentMapState.applyUpdate(this.store, this.changes, key, update, false, this.version);
        }

        @Override
        public void close() {
            if (this.changeCounter != null) {
                this.changeCounter.incrementAndGet();
                this.changeCounter = null;
            }
            super.close();
        }
    }
}

