/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.proc;

import java.util.Arrays;
import java.util.List;
import org.neo4j.helpers.collection.Iterables;

public class QualifiedName {
    private final String[] namespace;
    private final String name;

    public QualifiedName(List<String> namespace, String name) {
        this(namespace.toArray(new String[namespace.size()]), name);
    }

    public QualifiedName(String[] namespace, String name) {
        this.namespace = namespace;
        this.name = name;
    }

    public String[] namespace() {
        return this.namespace;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        String strNamespace = this.namespace.length > 0 ? Iterables.toString(Arrays.asList(this.namespace), (String)".") + "." : "";
        return String.format("%s%s", strNamespace, this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifiedName that = (QualifiedName)o;
        return Arrays.equals(this.namespace, that.namespace) && this.name.equals(that.name);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.namespace);
        result = 31 * result + this.name.hashCode();
        return result;
    }
}

