/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Arrays;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveArrays;
import org.neo4j.collection.primitive.PrimitiveLongCollection;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.cursor.Cursor;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.RelationshipItem;

class TwoPhaseNodeForRelationshipLocking {
    private final EntityReadOperations ops;
    private final ThrowingConsumer<Long, KernelException> relIdAction;
    private long firstRelId;
    private long[] sortedNodeIds;

    TwoPhaseNodeForRelationshipLocking(EntityReadOperations entityReadOperations, ThrowingConsumer<Long, KernelException> relIdAction) {
        this.ops = entityReadOperations;
        this.relIdAction = relIdAction;
    }

    void lockAllNodesAndConsumeRelationships(long nodeId, KernelStatement state) throws KernelException {
        boolean retry;
        do {
            retry = false;
            this.firstRelId = -1L;
            this.collectAndSortNodeIds(nodeId, state);
            this.lockAllNodes(state, this.sortedNodeIds);
            try (Cursor<NodeItem> node = this.ops.nodeCursorById(state, nodeId);
                 Cursor<RelationshipItem> relationships = this.ops.nodeGetRelationships(state, (NodeItem)node.get(), Direction.BOTH);){
                boolean first = true;
                while (relationships.next() && !retry) {
                    retry = this.performAction(state, (RelationshipItem)relationships.get(), first);
                    first = false;
                }
            }
        } while (retry);
    }

    private void collectAndSortNodeIds(long nodeId, KernelStatement state) throws EntityNotFoundException {
        PrimitiveLongSet nodeIdSet = Primitive.longSet();
        nodeIdSet.add(nodeId);
        try (Cursor<NodeItem> node = this.ops.nodeCursorById(state, nodeId);
             Cursor<RelationshipItem> rels = this.ops.nodeGetRelationships(state, (NodeItem)node.get(), Direction.BOTH);){
            while (rels.next()) {
                RelationshipItem rel = (RelationshipItem)rels.get();
                if (this.firstRelId == -1L) {
                    this.firstRelId = rel.id();
                }
                nodeIdSet.add(rel.startNode());
                nodeIdSet.add(rel.endNode());
            }
        }
        long[] nodeIds = PrimitiveArrays.of((PrimitiveLongCollection)nodeIdSet);
        Arrays.sort(nodeIds);
        this.sortedNodeIds = nodeIds;
    }

    private void lockAllNodes(KernelStatement state, long[] nodeIds) {
        state.locks().optimistic().acquireExclusive(state.lockTracer(), ResourceTypes.NODE, nodeIds);
    }

    private void unlockAllNodes(KernelStatement state, long[] nodeIds) {
        for (long nodeId : nodeIds) {
            state.locks().optimistic().releaseExclusive(ResourceTypes.NODE, nodeId);
        }
    }

    private boolean performAction(KernelStatement state, RelationshipItem rel, boolean first) throws KernelException {
        if (first && rel.id() != this.firstRelId) {
            this.unlockAllNodes(state, this.sortedNodeIds);
            this.sortedNodeIds = null;
            return true;
        }
        this.relIdAction.accept((Object)rel.id());
        return false;
    }
}

