/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.neo4j.concurrent.Work;
import org.neo4j.concurrent.WorkSync;
import org.neo4j.helpers.Exceptions;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.FailureHeaderWriter;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexHeaderWriter;
import org.neo4j.kernel.impl.index.schema.NativeSchemaNumberIndex;
import org.neo4j.kernel.impl.index.schema.NativeSchemaNumberIndexUpdater;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;

public abstract class NativeSchemaNumberIndexPopulator<KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue>
extends NativeSchemaNumberIndex<KEY, VALUE>
implements IndexPopulator {
    static final byte BYTE_FAILED = 0;
    static final byte BYTE_ONLINE = 1;
    static final byte BYTE_POPULATING = 2;
    private final KEY treeKey;
    private final VALUE treeValue;
    private WorkSync<IndexUpdateApply, IndexUpdateWork> additionsWorkSync;
    private WorkSync<IndexUpdateApply, IndexUpdateWork> updatesWorkSync;
    private byte[] failureBytes;
    private boolean dropped;

    NativeSchemaNumberIndexPopulator(PageCache pageCache, FileSystemAbstraction fs, File storeFile, Layout<KEY, VALUE> layout, SchemaIndexProvider.Monitor monitor, IndexDescriptor descriptor, long indexId) {
        super(pageCache, fs, storeFile, layout, monitor, descriptor, indexId);
        this.treeKey = (SchemaNumberKey)((Object)layout.newKey());
        this.treeValue = (SchemaNumberValue)layout.newValue();
    }

    @Override
    public synchronized void create() throws IOException {
        this.gbpTreeFileUtil.deleteFileIfPresent(this.storeFile);
        this.instantiateTree(RecoveryCleanupWorkCollector.immediate(), new NativeSchemaIndexHeaderWriter(2));
        boolean compareIds = this.descriptor.type() == IndexDescriptor.Type.GENERAL;
        this.additionsWorkSync = new WorkSync((Object)new IndexUpdateApply(this, this.treeKey, this.treeValue, new ConflictDetectingValueMerger(compareIds)));
        this.updatesWorkSync = new WorkSync((Object)new IndexUpdateApply(this, this.treeKey, this.treeValue, new ConflictDetectingValueMerger(true)));
    }

    @Override
    public synchronized void drop() throws IOException {
        try {
            this.closeTree();
            this.gbpTreeFileUtil.deleteFileIfPresent(this.storeFile);
        }
        finally {
            this.dropped = true;
        }
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates) throws IndexEntryConflictException, IOException {
        this.applyWithWorkSync(this.additionsWorkSync, updates);
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
    }

    @Override
    public IndexUpdater newPopulatingUpdater(PropertyAccessor accessor) throws IOException {
        return new IndexUpdater(){
            private boolean closed;
            private final Collection<IndexEntryUpdate<?>> updates = new ArrayList();

            @Override
            public void process(IndexEntryUpdate<?> update) throws IOException, IndexEntryConflictException {
                this.assertOpen();
                this.updates.add(update);
            }

            @Override
            public void close() throws IOException, IndexEntryConflictException {
                NativeSchemaNumberIndexPopulator.this.applyWithWorkSync((WorkSync<IndexUpdateApply, IndexUpdateWork>)NativeSchemaNumberIndexPopulator.this.updatesWorkSync, this.updates);
                this.closed = true;
            }

            private void assertOpen() {
                if (this.closed) {
                    throw new IllegalStateException("Updater has been closed");
                }
            }
        };
    }

    @Override
    public synchronized void close(boolean populationCompletedSuccessfully) throws IOException {
        if (populationCompletedSuccessfully && this.failureBytes != null) {
            throw new IllegalStateException("Can't mark index as online after it has been marked as failure");
        }
        try {
            if (populationCompletedSuccessfully) {
                this.assertPopulatorOpen();
                this.markTreeAsOnline();
            } else {
                this.assertNotDropped();
                this.ensureTreeInstantiated();
                this.markTreeAsFailed();
            }
        }
        finally {
            this.closeTree();
        }
    }

    private void applyWithWorkSync(WorkSync<IndexUpdateApply, IndexUpdateWork> workSync, Collection<? extends IndexEntryUpdate<?>> updates) throws IOException, IndexEntryConflictException {
        try {
            workSync.apply((Work)new IndexUpdateWork(updates));
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof IndexEntryConflictException) {
                throw (IndexEntryConflictException)cause;
            }
            throw Exceptions.launderedException((Throwable)e);
        }
    }

    private void assertNotDropped() {
        if (this.dropped) {
            throw new IllegalStateException("Populator has already been dropped.");
        }
    }

    @Override
    public void markAsFailed(String failure) throws IOException {
        this.failureBytes = failure.getBytes(StandardCharsets.UTF_8);
    }

    private void ensureTreeInstantiated() throws IOException {
        if (this.tree == null) {
            this.instantiateTree(RecoveryCleanupWorkCollector.ignore(), GBPTree.NO_HEADER_WRITER);
        }
    }

    private void assertPopulatorOpen() {
        if (this.tree == null) {
            throw new IllegalStateException("Populator has already been closed.");
        }
    }

    private void markTreeAsFailed() throws IOException {
        if (this.failureBytes == null) {
            this.failureBytes = new byte[0];
        }
        this.tree.checkpoint(IOLimiter.unlimited(), (Consumer)new FailureHeaderWriter(this.failureBytes));
    }

    private void markTreeAsOnline() throws IOException {
        this.tree.checkpoint(IOLimiter.unlimited(), pc -> pc.putByte((byte)1));
    }

    private class IndexUpdateWork
    implements Work<IndexUpdateApply, IndexUpdateWork> {
        private final Collection<? extends IndexEntryUpdate<?>> updates;

        IndexUpdateWork(Collection<? extends IndexEntryUpdate<?>> updates) {
            this.updates = updates;
        }

        public IndexUpdateWork combine(IndexUpdateWork work) {
            ArrayList combined = new ArrayList(this.updates);
            combined.addAll(work.updates);
            return new IndexUpdateWork(combined);
        }

        public void apply(IndexUpdateApply indexUpdateApply) throws Exception {
            indexUpdateApply.process(this.updates);
        }
    }

    private static class IndexUpdateApply {
        private final KEY treeKey;
        private final VALUE treeValue;
        private final ConflictDetectingValueMerger<KEY, VALUE> conflictDetectingValueMerger;
        final /* synthetic */ NativeSchemaNumberIndexPopulator this$0;

        IndexUpdateApply(KEY treeKey, VALUE treeValue, ConflictDetectingValueMerger<KEY, VALUE> conflictDetectingValueMerger) {
            this.this$0 = var1_1;
            this.treeKey = treeKey;
            this.treeValue = treeValue;
            this.conflictDetectingValueMerger = conflictDetectingValueMerger;
        }

        void process(Iterable<? extends IndexEntryUpdate<?>> indexEntryUpdates) throws Exception {
            try (Writer writer = this.this$0.tree.writer();){
                for (IndexEntryUpdate<?> indexEntryUpdate : indexEntryUpdates) {
                    NativeSchemaNumberIndexUpdater.processUpdate(this.treeKey, this.treeValue, indexEntryUpdate, writer, this.conflictDetectingValueMerger);
                }
            }
        }
    }
}

