/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.UniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.DeferredConflictCheckingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NativeSchemaNumberIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeSchemaNumberIndexReader;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;
import org.neo4j.storageengine.api.schema.IndexSample;

class NativeUniqueSchemaNumberIndexPopulator<KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue>
extends NativeSchemaNumberIndexPopulator<KEY, VALUE> {
    private final UniqueIndexSampler sampler;
    private final IndexSamplingConfig samplingConfig;

    NativeUniqueSchemaNumberIndexPopulator(PageCache pageCache, FileSystemAbstraction fs, File storeFile, Layout<KEY, VALUE> layout, IndexSamplingConfig samplingConfig, SchemaIndexProvider.Monitor monitor, IndexDescriptor descriptor, long indexId) {
        super(pageCache, fs, storeFile, layout, monitor, descriptor, indexId);
        this.samplingConfig = samplingConfig;
        this.sampler = new UniqueIndexSampler();
    }

    @Override
    public void includeSample(IndexEntryUpdate<?> update) {
        this.sampler.increment(1L);
    }

    @Override
    public IndexSample sampleResult() {
        return this.sampler.result();
    }

    @Override
    public IndexUpdater newPopulatingUpdater(PropertyAccessor accessor) throws IOException {
        return new DeferredConflictCheckingIndexUpdater(super.newPopulatingUpdater(accessor), () -> new NativeSchemaNumberIndexReader(this.tree, this.layout, this.samplingConfig), this.descriptor);
    }
}

