/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.List;
import java.util.function.Function;
import org.neo4j.kernel.api.proc.FieldSignature;
import org.neo4j.kernel.impl.proc.Neo4jValue;
import org.neo4j.kernel.impl.proc.ParseUtil;

public class ByteArrayConverter
implements Function<String, Neo4jValue>,
FieldSignature.InputMapper {
    @Override
    public Neo4jValue apply(String s) {
        String value = s.trim();
        if (value.equalsIgnoreCase("null")) {
            return Neo4jValue.ntByteArray(null);
        }
        List values = ParseUtil.parseList(value, Long.class);
        byte[] bytes = new byte[values.size()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = ((Long)values.get(i)).byteValue();
        }
        return Neo4jValue.ntByteArray(bytes);
    }

    @Override
    public Object map(Object input) {
        if (input instanceof byte[]) {
            return input;
        }
        if (input instanceof List) {
            List list = (List)input;
            byte[] bytes = new byte[list.size()];
            for (int a = 0; a < bytes.length; ++a) {
                Object value = list.get(a);
                if (!(value instanceof Byte)) {
                    throw new IllegalArgumentException("Cannot convert " + value + " to byte for input to procedure");
                }
                bytes[a] = (Byte)value;
            }
            return bytes;
        }
        throw new IllegalArgumentException("Cannot convert " + input.getClass().getSimpleName() + " to byte[] for input to procedure");
    }
}

