/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.query.ExecutingQueryStatus;

class WaitingOnQuery
extends ExecutingQueryStatus {
    private final ExecutingQuery query;
    private final long startTimeNanos;

    WaitingOnQuery(ExecutingQuery query, long startTimeNanos) {
        this.query = query;
        this.startTimeNanos = startTimeNanos;
    }

    @Override
    long waitTimeNanos(long currentTimeNanos) {
        return currentTimeNanos - this.startTimeNanos;
    }

    @Override
    Map<String, Object> toMap(long currentTimeNanos) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("queryId", "query-" + this.query.internalQueryId());
        map.put("waitTimeMillis", TimeUnit.NANOSECONDS.toMillis(this.waitTimeNanos(currentTimeNanos)));
        return map;
    }

    @Override
    String name() {
        return "waiting";
    }
}

