/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;

class ConflictDetectingValueMerger<KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue>
implements ValueMerger<KEY, VALUE> {
    private final boolean compareEntityIds;
    private boolean conflict;
    private long existingNodeId;
    private long addedNodeId;

    ConflictDetectingValueMerger(boolean compareEntityIds) {
        this.compareEntityIds = compareEntityIds;
    }

    public VALUE merge(KEY existingKey, KEY newKey, VALUE existingValue, VALUE newValue) {
        if (((SchemaNumberKey)((Object)existingKey)).entityId != ((SchemaNumberKey)((Object)newKey)).entityId) {
            this.conflict = true;
            this.existingNodeId = ((SchemaNumberKey)((Object)existingKey)).entityId;
            this.addedNodeId = ((SchemaNumberKey)((Object)newKey)).entityId;
        }
        return null;
    }

    void controlConflictDetection(KEY key) {
        ((SchemaNumberKey)((Object)key)).entityIdIsSpecialTieBreaker = this.compareEntityIds;
    }

    void checkConflict(Value[] values) throws IndexEntryConflictException {
        if (this.conflict) {
            this.conflict = false;
            throw new IndexEntryConflictException(this.existingNodeId, this.addedNodeId, ValueTuple.of((Value[])values));
        }
    }
}

