/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaUtil;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;

public class NodePropertyExistenceException
extends ConstraintValidationException {
    private final long nodeId;
    private final LabelSchemaDescriptor schema;

    public NodePropertyExistenceException(LabelSchemaDescriptor schema, ConstraintValidationException.Phase phase, long nodeId) {
        super(ConstraintDescriptorFactory.existsForSchema(schema), phase, String.format("Node(%d)", nodeId));
        this.schema = schema;
        this.nodeId = nodeId;
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        String propertyNoun = this.schema.getPropertyIds().length > 1 ? "properties" : "property";
        return String.format("Node(%d) with label `%s` must have the %s `%s`", this.nodeId, tokenNameLookup.labelGetName(this.schema.getLabelId()), propertyNoun, SchemaUtil.niceProperties(tokenNameLookup, this.schema.getPropertyIds()));
    }
}

