/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Map;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.logging.Log;

public class LoggingMonitor
implements SchemaIndexProvider.Monitor {
    private final Log log;

    public LoggingMonitor(Log log) {
        this.log = log;
    }

    @Override
    public void failedToOpenIndex(long indexId, IndexDescriptor indexDescriptor, String action, Exception cause) {
        this.log.error("Failed to open index:" + indexId + ". " + action, (Throwable)cause);
    }

    @Override
    public void recoveryCompleted(long indexId, IndexDescriptor indexDescriptor, Map<String, Object> data) {
        StringBuilder builder = new StringBuilder("Schema index recovery completed: indexId: " + indexId + " descriptor: " + indexDescriptor.toString());
        data.forEach((key, value) -> builder.append(String.format(" %s: %s", key, value)));
        this.log.info(builder.toString());
    }
}

