/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema.constaints;

import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.schema.SchemaDescriptor;

public abstract class ConstraintDescriptor
implements SchemaDescriptor.Supplier {
    private final Type type;

    ConstraintDescriptor(Type type) {
        this.type = type;
    }

    @Override
    public abstract SchemaDescriptor schema();

    public Type type() {
        return this.type;
    }

    public boolean enforcesUniqueness() {
        return this.type.enforcesUniqueness();
    }

    public boolean enforcesPropertyExistence() {
        return this.type.enforcesPropertyExistence();
    }

    public String userDescription(TokenNameLookup tokenNameLookup) {
        return String.format("Constraint( %s, %s )", this.type.name(), this.schema().userDescription(tokenNameLookup));
    }

    public final boolean isSame(Supplier supplier) {
        return this.equals(supplier.getConstraintDescriptor());
    }

    public final boolean equals(Object o) {
        if (o != null && o instanceof ConstraintDescriptor) {
            ConstraintDescriptor that = (ConstraintDescriptor)o;
            return this.type() == that.type() && this.schema().equals(that.schema());
        }
        return false;
    }

    public final int hashCode() {
        return this.type.hashCode() & this.schema().hashCode();
    }

    public abstract String prettyPrint(TokenNameLookup var1);

    String escapeLabelOrRelTyp(String name) {
        if (name.contains(":")) {
            return "`" + name + "`";
        }
        return name;
    }

    public static interface Supplier {
        public ConstraintDescriptor getConstraintDescriptor();
    }

    public static enum Type {
        UNIQUE(true, false),
        EXISTS(false, true),
        UNIQUE_EXISTS(true, true);

        private final boolean isUnique;
        private final boolean mustExist;

        private Type(boolean isUnique, boolean mustExist) {
            this.isUnique = isUnique;
            this.mustExist = mustExist;
        }

        private boolean enforcesUniqueness() {
            return this.isUnique;
        }

        private boolean enforcesPropertyExistence() {
            return this.mustExist;
        }
    }
}

