/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.time.SystemNanoClock;

public class TransactionExecutionStatistic {
    static final TransactionExecutionStatistic NOT_AVAILABLE = new TransactionExecutionStatistic();
    private final Long heapAllocateBytes;
    private final Long cpuTimeMillis;
    private final long waitTimeMillis;
    private final long elapsedTimeMillis;
    private final Long idleTimeMillis;
    private final long pageFaults;
    private final long pageHits;

    private TransactionExecutionStatistic() {
        this.heapAllocateBytes = null;
        this.cpuTimeMillis = null;
        this.waitTimeMillis = -1L;
        this.elapsedTimeMillis = -1L;
        this.idleTimeMillis = null;
        this.pageFaults = 0L;
        this.pageHits = 0L;
    }

    public TransactionExecutionStatistic(KernelTransactionImplementation tx, SystemNanoClock clock, long startTimeMillis) {
        long nowMillis = clock.millis();
        long nowNanos = clock.nanos();
        KernelTransactionImplementation.Statistics statistics = tx.getStatistics();
        this.waitTimeMillis = TimeUnit.NANOSECONDS.toMillis(statistics.getWaitingTimeNanos(nowNanos));
        long heapAllocateBytes = statistics.heapAllocateBytes();
        this.heapAllocateBytes = heapAllocateBytes >= 0L ? Long.valueOf(heapAllocateBytes) : null;
        long cpuTimeMillis = statistics.cpuTimeMillis();
        this.cpuTimeMillis = cpuTimeMillis >= 0L ? Long.valueOf(cpuTimeMillis) : null;
        this.pageFaults = statistics.totalTransactionPageCacheFaults();
        this.pageHits = statistics.totalTransactionPageCacheHits();
        this.elapsedTimeMillis = nowMillis - startTimeMillis;
        this.idleTimeMillis = this.cpuTimeMillis != null ? Long.valueOf(this.elapsedTimeMillis - this.cpuTimeMillis - this.waitTimeMillis) : null;
    }

    public Long getHeapAllocateBytes() {
        return this.heapAllocateBytes;
    }

    public Long getCpuTimeMillis() {
        return this.cpuTimeMillis;
    }

    public long getWaitTimeMillis() {
        return this.waitTimeMillis;
    }

    public long getElapsedTimeMillis() {
        return this.elapsedTimeMillis;
    }

    public Long getIdleTimeMillis() {
        return this.idleTimeMillis;
    }

    public long getPageHits() {
        return this.pageHits;
    }

    public long getPageFaults() {
        return this.pageFaults;
    }
}

