/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.index.GBPTreeFileUtil;

public class GBPTreeFileSystemFileUtil
implements GBPTreeFileUtil {
    private final FileSystemAbstraction fs;

    public GBPTreeFileSystemFileUtil(FileSystemAbstraction fs) {
        this.fs = fs;
    }

    @Override
    public void deleteFile(File storeFile) throws IOException {
        this.fs.deleteFileOrThrow(storeFile);
    }

    @Override
    public void deleteFileIfPresent(File storeFile) throws IOException {
        try {
            this.deleteFile(storeFile);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    @Override
    public boolean storeFileExists(File storeFile) {
        return this.fs.fileExists(storeFile);
    }

    @Override
    public void mkdirs(File dir) throws IOException {
        this.fs.mkdirs(dir);
    }
}

