/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.cursor.RawCursor;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.FullScanNonUniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.NativeSchemaNumberIndexProvider;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.kernel.impl.index.schema.NumberHitIndexProgressor;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

class NativeSchemaNumberIndexReader<KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue>
implements IndexReader {
    private final GBPTree<KEY, VALUE> tree;
    private final Layout<KEY, VALUE> layout;
    private final IndexSamplingConfig samplingConfig;
    private final Set<RawCursor<Hit<KEY, VALUE>, IOException>> openSeekers;
    private final int[] propertyKeys;

    NativeSchemaNumberIndexReader(GBPTree<KEY, VALUE> tree, Layout<KEY, VALUE> layout, IndexSamplingConfig samplingConfig, int[] propertyKeys) {
        this.tree = tree;
        this.layout = layout;
        this.samplingConfig = samplingConfig;
        this.propertyKeys = propertyKeys;
        this.openSeekers = new HashSet<RawCursor<Hit<KEY, VALUE>, IOException>>();
    }

    public void close() {
        this.ensureOpenSeekersClosed();
    }

    @Override
    public IndexSampler createSampler() {
        FullScanNonUniqueIndexSampler<KEY, VALUE> sampler = new FullScanNonUniqueIndexSampler<KEY, VALUE>(this.tree, this.layout, this.samplingConfig);
        return sampler::result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long countIndexedNodes(long nodeId, Value ... propertyValues) {
        SchemaNumberKey treeKeyFrom = (SchemaNumberKey)((Object)this.layout.newKey());
        SchemaNumberKey treeKeyTo = (SchemaNumberKey)((Object)this.layout.newKey());
        treeKeyFrom.from(nodeId, propertyValues);
        treeKeyTo.from(nodeId, propertyValues);
        try (RawCursor seeker = this.tree.seek((Object)treeKeyFrom, (Object)treeKeyTo);){
            long count = 0L;
            while (seeker.next()) {
                if (((SchemaNumberKey)((Object)((Hit)seeker.get()).key())).entityId != nodeId) continue;
                ++count;
            }
            long l = count;
            return l;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public PrimitiveLongResourceIterator query(IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        NodeValueIterator nodeValueIterator = new NodeValueIterator();
        this.query(nodeValueIterator, IndexOrder.NONE, predicates);
        return nodeValueIterator;
    }

    @Override
    public void query(IndexProgressor.NodeValueClient cursor, IndexOrder indexOrder, IndexQuery ... predicates) {
        this.validateQuery(indexOrder, predicates);
        SchemaNumberKey treeKeyFrom = (SchemaNumberKey)((Object)this.layout.newKey());
        SchemaNumberKey treeKeyTo = (SchemaNumberKey)((Object)this.layout.newKey());
        IndexQuery predicate = predicates[0];
        switch (predicate.type()) {
            case exists: {
                treeKeyFrom.initAsLowest();
                treeKeyTo.initAsHighest();
                this.startSeekForInitializedRange(cursor, treeKeyFrom, treeKeyTo);
                break;
            }
            case exact: {
                IndexQuery.ExactPredicate exactPredicate = (IndexQuery.ExactPredicate)predicate;
                treeKeyFrom.from(Long.MIN_VALUE, exactPredicate.value());
                treeKeyTo.from(Long.MAX_VALUE, exactPredicate.value());
                this.startSeekForInitializedRange(cursor, treeKeyFrom, treeKeyTo);
                break;
            }
            case rangeNumeric: {
                IndexQuery.NumberRangePredicate rangePredicate = (IndexQuery.NumberRangePredicate)predicate;
                this.initFromForRange(rangePredicate, treeKeyFrom);
                this.initToForRange(rangePredicate, treeKeyTo);
                this.startSeekForInitializedRange(cursor, treeKeyFrom, treeKeyTo);
                break;
            }
            default: {
                throw new IllegalArgumentException("IndexQuery of type " + predicate.type() + " is not supported.");
            }
        }
    }

    private void validateQuery(IndexOrder indexOrder, IndexQuery[] predicates) {
        if (predicates.length != 1) {
            throw new UnsupportedOperationException();
        }
        if (indexOrder != IndexOrder.NONE) {
            ValueGroup valueGroup = predicates[0].valueGroup();
            Object[] capability = NativeSchemaNumberIndexProvider.CAPABILITY.orderCapability(new ValueGroup[]{valueGroup});
            if (!ArrayUtil.contains(capability, indexOrder)) {
                capability = (IndexOrder[])ArrayUtils.add((Object[])capability, (Object)IndexOrder.NONE);
                throw new UnsupportedOperationException(String.format("Tried to query index with unsupported order %s. Supported orders for query %s are %s.", indexOrder, Arrays.toString(predicates), Arrays.toString(capability)));
            }
        }
    }

    private void initToForRange(IndexQuery.NumberRangePredicate rangePredicate, KEY treeKeyTo) {
        Value toValue = rangePredicate.toAsValue();
        if (toValue.valueGroup() == ValueGroup.NO_VALUE) {
            ((SchemaNumberKey)((Object)treeKeyTo)).initAsHighest();
        } else {
            ((SchemaNumberKey)((Object)treeKeyTo)).from(rangePredicate.toInclusive() ? Long.MAX_VALUE : Long.MIN_VALUE, toValue);
            ((SchemaNumberKey)((Object)treeKeyTo)).entityIdIsSpecialTieBreaker = true;
        }
    }

    private void initFromForRange(IndexQuery.NumberRangePredicate rangePredicate, KEY treeKeyFrom) {
        Value fromValue = rangePredicate.fromAsValue();
        if (fromValue.valueGroup() == ValueGroup.NO_VALUE) {
            ((SchemaNumberKey)((Object)treeKeyFrom)).initAsLowest();
        } else {
            ((SchemaNumberKey)((Object)treeKeyFrom)).from(rangePredicate.fromInclusive() ? Long.MIN_VALUE : Long.MAX_VALUE, fromValue);
            ((SchemaNumberKey)((Object)treeKeyFrom)).entityIdIsSpecialTieBreaker = true;
        }
    }

    @Override
    public boolean hasFullNumberPrecision(IndexQuery ... predicates) {
        return true;
    }

    private void startSeekForInitializedRange(IndexProgressor.NodeValueClient client, KEY treeKeyFrom, KEY treeKeyTo) {
        if (this.layout.compare(treeKeyFrom, treeKeyTo) > 0) {
            client.initialize(IndexProgressor.EMPTY, this.propertyKeys);
            return;
        }
        try {
            RawCursor seeker = this.tree.seek(treeKeyFrom, treeKeyTo);
            this.openSeekers.add(seeker);
            NumberHitIndexProgressor<KEY, VALUE> hitProgressor = new NumberHitIndexProgressor<KEY, VALUE>(seeker, client, this.openSeekers);
            client.initialize(hitProgressor, this.propertyKeys);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void ensureOpenSeekersClosed() {
        try {
            IOUtils.closeAll(this.openSeekers);
            this.openSeekers.clear();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

