/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;

abstract class NumberLayout
extends Layout.Adapter<SchemaNumberKey, SchemaNumberValue> {
    NumberLayout() {
    }

    public SchemaNumberKey newKey() {
        return new SchemaNumberKey();
    }

    public SchemaNumberKey copyKey(SchemaNumberKey key, SchemaNumberKey into) {
        into.type = key.type;
        into.rawValueBits = key.rawValueBits;
        into.entityId = key.entityId;
        into.entityIdIsSpecialTieBreaker = key.entityIdIsSpecialTieBreaker;
        return into;
    }

    public SchemaNumberValue newValue() {
        return SchemaNumberValue.INSTANCE;
    }

    public int keySize() {
        return 17;
    }

    public int valueSize() {
        return 0;
    }

    public void writeKey(PageCursor cursor, SchemaNumberKey key) {
        cursor.putByte(key.type);
        cursor.putLong(key.rawValueBits);
        cursor.putLong(key.entityId);
    }

    public void writeValue(PageCursor cursor, SchemaNumberValue value) {
    }

    public void readKey(PageCursor cursor, SchemaNumberKey into) {
        into.type = cursor.getByte();
        into.rawValueBits = cursor.getLong();
        into.entityId = cursor.getLong();
    }

    public void readValue(PageCursor cursor, SchemaNumberValue into) {
    }
}

