/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import java.util.Collection;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.internal.kernel.api.LabelSet;

class Labels
implements LabelSet {
    private final long[] labels;

    Labels(long[] labels) {
        this.labels = labels;
    }

    static Labels from(Collection<Integer> integers) {
        int size = integers.size();
        long[] tokens = new long[size];
        int i = 0;
        for (Integer token : integers) {
            tokens[i++] = token.intValue();
        }
        return new Labels(tokens);
    }

    static Labels from(PrimitiveIntSet set) {
        long[] labelArray = new long[set.size()];
        int index = 0;
        PrimitiveIntIterator iterator = set.iterator();
        while (iterator.hasNext()) {
            labelArray[index++] = iterator.next();
        }
        return new Labels(labelArray);
    }

    public int numberOfLabels() {
        return this.labels.length;
    }

    public int label(int offset) {
        return (int)this.labels[offset];
    }

    public boolean contains(int labelToken) {
        for (long label : this.labels) {
            if (label != (long)labelToken) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Labels" + Arrays.toString(this.labels);
    }
}

