/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import java.util.Comparator;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.impl.newapi.NodeCursor;
import org.neo4j.kernel.impl.newapi.PropertyCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.values.storable.Value;

class NodeValueClientFilter
implements IndexProgressor.NodeValueClient,
IndexProgressor {
    private static final Comparator<IndexQuery> ASCENDING_BY_KEY = Comparator.comparingInt(IndexQuery::propertyKeyId);
    private final IndexProgressor.NodeValueClient target;
    private final NodeCursor node;
    private final PropertyCursor property;
    private final IndexQuery[] filters;
    private final Read read;
    private int[] keys;
    private IndexProgressor progressor;

    NodeValueClientFilter(IndexProgressor.NodeValueClient target, NodeCursor node, PropertyCursor property, Read read, IndexQuery ... filters) {
        this.target = target;
        this.node = node;
        this.property = property;
        this.filters = filters;
        this.read = read;
        Arrays.sort(filters, ASCENDING_BY_KEY);
    }

    @Override
    public void initialize(IndexProgressor progressor, int[] propertyIds) {
        this.progressor = progressor;
        this.keys = propertyIds;
        this.target.initialize(this, propertyIds);
    }

    @Override
    public boolean acceptNode(long reference, Value[] values) {
        if (this.keys != null && values != null) {
            return this.filterByIndexValues(reference, values);
        }
        this.node.single(reference, this.read);
        if (!this.node.next()) {
            this.property.clear();
            return false;
        }
        this.node.properties(this.property);
        return this.filterByCursors(reference, values);
    }

    @Override
    public boolean next() {
        return this.progressor.next();
    }

    @Override
    public void close() {
        this.node.close();
        this.property.close();
        this.progressor.close();
    }

    private boolean filterByIndexValues(long reference, Value[] values) {
        block0: for (IndexQuery filter : this.filters) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] != filter.propertyKeyId()) continue;
                if (filter.acceptsValue(values[i])) continue block0;
                return false;
            }
            assert (false) : "Cannot satisfy filter " + filter + " - no corresponding key!";
            return false;
        }
        return this.target.acceptNode(reference, values);
    }

    private boolean filterByCursors(long reference, Value[] values) {
        int accepted = 0;
        block0: while (this.property.next()) {
            for (IndexQuery filter : this.filters) {
                if (filter.propertyKeyId() == this.property.propertyKey()) {
                    if (!filter.acceptsValueAt((org.neo4j.internal.kernel.api.PropertyCursor)this.property)) {
                        return false;
                    }
                    ++accepted;
                    continue;
                }
                if (this.property.propertyKey() < filter.propertyKeyId()) continue block0;
            }
        }
        if (accepted < this.filters.length) {
            return false;
        }
        return this.target.acceptNode(reference, values);
    }
}

