/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import org.neo4j.helpers.ArrayUtil;
import org.neo4j.kernel.impl.store.format.CapabilityType;

public enum Capability {
    SCHEMA(CapabilityType.STORE),
    DENSE_NODES(CapabilityType.FORMAT, CapabilityType.STORE),
    RELATIONSHIP_TYPE_3BYTES(CapabilityType.FORMAT, CapabilityType.STORE),
    VERSION_TRAILERS(CapabilityType.STORE),
    LUCENE_3(CapabilityType.INDEX),
    LUCENE_5(CapabilityType.INDEX),
    POINT_PROPERTIES(CapabilityType.STORE),
    SECONDARY_RECORD_UNITS(CapabilityType.FORMAT);

    private final CapabilityType[] types;

    private Capability(CapabilityType ... types) {
        this.types = types;
    }

    public boolean isType(CapabilityType type) {
        return ArrayUtil.contains(this.types, type);
    }
}

